/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.ratis.util.Preconditions;

public interface ChecksumByteBuffer
extends Checksum {
    @Override
    public void update(ByteBuffer var1);

    @Override
    default public void update(byte[] b, int off, int len) {
        this.update(ByteBuffer.wrap(b, off, len).asReadOnlyBuffer());
    }

    public static abstract class CrcIntTable
    implements ChecksumByteBuffer {
        private int crc;

        CrcIntTable() {
            this.reset();
            Preconditions.assertTrue((this.getTable().length == 2048 ? 1 : 0) != 0);
        }

        abstract int[] getTable();

        @Override
        public final long getValue() {
            return (long)(~this.crc) & 0xFFFFFFFFL;
        }

        @Override
        public final void reset() {
            this.crc = -1;
        }

        @Override
        public final void update(int b) {
            this.crc = this.crc >>> 8 ^ this.getTable()[(this.crc ^ b) << 24 >>> 24];
        }

        @Override
        public final void update(ByteBuffer b) {
            this.crc = CrcIntTable.update(this.crc, b, this.getTable());
        }

        private static int update(int crc, ByteBuffer b, int[] table) {
            while (b.remaining() > 7) {
                int c0 = (b.get() ^ crc) & 0xFF;
                int c1 = (b.get() ^ (crc >>>= 8)) & 0xFF;
                int c2 = (b.get() ^ (crc >>>= 8)) & 0xFF;
                int c3 = (b.get() ^ crc >>> 8) & 0xFF;
                crc = table[1792 + c0] ^ table[1536 + c1] ^ (table[1280 + c2] ^ table[1024 + c3]);
                int c4 = b.get() & 0xFF;
                int c5 = b.get() & 0xFF;
                int c6 = b.get() & 0xFF;
                int c7 = b.get() & 0xFF;
                crc ^= table[768 + c4] ^ table[512 + c5] ^ (table[256 + c6] ^ table[c7]);
            }
            switch (b.remaining()) {
                case 7: {
                    crc = crc >>> 8 ^ table[(crc ^ b.get()) & 0xFF];
                }
                case 6: {
                    crc = crc >>> 8 ^ table[(crc ^ b.get()) & 0xFF];
                }
                case 5: {
                    crc = crc >>> 8 ^ table[(crc ^ b.get()) & 0xFF];
                }
                case 4: {
                    crc = crc >>> 8 ^ table[(crc ^ b.get()) & 0xFF];
                }
                case 3: {
                    crc = crc >>> 8 ^ table[(crc ^ b.get()) & 0xFF];
                }
                case 2: {
                    crc = crc >>> 8 ^ table[(crc ^ b.get()) & 0xFF];
                }
                case 1: {
                    crc = crc >>> 8 ^ table[(crc ^ b.get()) & 0xFF];
                }
            }
            return crc;
        }
    }
}

