/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.ratis.util.AtomicFileOutputStream;
import org.slf4j.Logger;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.inspector.TrustedPrefixesTagInspector;

public final class YamlUtils {
    private static final Yaml LOADER = YamlUtils.getYamlForLoad();

    private YamlUtils() {
    }

    public static <T> T loadAs(InputStream input, Class<? super T> type) {
        return (T)LOADER.loadAs(input, type);
    }

    private static Yaml getYamlForLoad() {
        TrustedPrefixesTagInspector tags = new TrustedPrefixesTagInspector(Arrays.asList("org.apache.hadoop.ozone.", "org.apache.hadoop.hdds."));
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setTagInspector((TagInspector)tags);
        return new Yaml(loaderOptions);
    }

    public static void dump(Yaml yaml, Object data, File file, Logger log) throws IOException {
        try (AtomicFileOutputStream out = new AtomicFileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            yaml.dump(data, (Writer)writer);
        }
        catch (IOException e) {
            log.warn("Failed to dump {}", data, (Object)e);
            throw e;
        }
    }
}

