/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Supplier;
import net.jcip.annotations.Immutable;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.ratis.util.MemoizedSupplier;

@Immutable
public final class ContainerID
implements Comparable<ContainerID> {
    private static final Codec<ContainerID> CODEC = new DelegatedCodec<ContainerID, Long>(LongCodec.get(), ContainerID::valueOf, c -> c.id, ContainerID.class, DelegatedCodec.CopyType.SHALLOW);
    public static final ContainerID MIN = ContainerID.valueOf(0L);
    private final long id;
    private final Supplier<HddsProtos.ContainerID> proto;
    private final Supplier<Integer> hash;

    public static Codec<ContainerID> getCodec() {
        return CODEC;
    }

    private ContainerID(long id) {
        Preconditions.checkState((id >= 0L ? 1 : 0) != 0, (String)"Container ID should be positive. %s.", (long)id);
        this.id = id;
        this.proto = MemoizedSupplier.valueOf(() -> HddsProtos.ContainerID.newBuilder().setId(id).build());
        this.hash = MemoizedSupplier.valueOf(() -> 4331 + Long.hashCode(id));
    }

    public static ContainerID valueOf(long containerID) {
        return new ContainerID(containerID);
    }

    @Deprecated
    public long getId() {
        return this.id;
    }

    public static byte[] getBytes(long id) {
        return LongCodec.get().toPersistedFormat(id);
    }

    public HddsProtos.ContainerID getProtobuf() {
        return this.proto.get();
    }

    public static ContainerID getFromProtobuf(HddsProtos.ContainerID proto) {
        return ContainerID.valueOf(proto.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerID that = (ContainerID)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.hash.get();
    }

    @Override
    public int compareTo(@Nonnull ContainerID that) {
        Objects.requireNonNull(that, "that == null");
        return Long.compare(this.id, that.id);
    }

    public String toString() {
        return "#" + this.id;
    }
}

