/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.upgrade;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.ozone.recon.upgrade.ReconUpgradeAction;
import org.apache.hadoop.ozone.recon.upgrade.UpgradeActionRecon;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public enum ReconLayoutFeature {
    INITIAL_VERSION(0, "Recon Layout Versioning Introduction"),
    TASK_STATUS_STATISTICS(1, "Recon Task Status Statistics Tracking Introduced");

    private final int version;
    private final String description;
    private final EnumMap<ReconUpgradeAction.UpgradeActionType, ReconUpgradeAction> actions = new EnumMap(ReconUpgradeAction.UpgradeActionType.class);

    private ReconLayoutFeature(int version, String description) {
        this.version = version;
        this.description = description;
    }

    public int getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<ReconUpgradeAction> getAction(ReconUpgradeAction.UpgradeActionType type) {
        return Optional.ofNullable(this.actions.get((Object)type));
    }

    public void addAction(ReconUpgradeAction.UpgradeActionType type, ReconUpgradeAction action) {
        this.actions.put(type, action);
    }

    public static void registerUpgradeActions() {
        Reflections reflections = new Reflections("org.apache.hadoop.ozone.recon.upgrade", new Scanner[0]);
        Set actionClasses = reflections.getTypesAnnotatedWith(UpgradeActionRecon.class);
        for (Class actionClass : actionClasses) {
            try {
                ReconUpgradeAction action = (ReconUpgradeAction)actionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                UpgradeActionRecon annotation = actionClass.getAnnotation(UpgradeActionRecon.class);
                annotation.feature().addAction(annotation.type(), action);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register upgrade action: " + actionClass.getSimpleName(), e);
            }
        }
    }

    public static int determineSLV() {
        return Arrays.stream(ReconLayoutFeature.values()).mapToInt(ReconLayoutFeature::getVersion).max().orElse(0);
    }

    public static ReconLayoutFeature[] getValues() {
        return ReconLayoutFeature.values();
    }
}

