/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OmTableHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenKeysInsightHandler
implements OmTableHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OpenKeysInsightHandler.class);

    @Override
    public void handlePutEvent(OMDBUpdateEvent<String, Object> event, String tableName, Map<String, Long> objectCountMap, Map<String, Long> unReplicatedSizeMap, Map<String, Long> replicatedSizeMap) {
        if (event.getValue() != null) {
            OmKeyInfo omKeyInfo = (OmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(this.getTableCountKeyFromTable(tableName), (k, count) -> count + 1L);
            unReplicatedSizeMap.computeIfPresent(this.getUnReplicatedSizeKeyFromTable(tableName), (k, size) -> size + omKeyInfo.getDataSize());
            replicatedSizeMap.computeIfPresent(this.getReplicatedSizeKeyFromTable(tableName), (k, size) -> size + omKeyInfo.getReplicatedSize());
        } else {
            LOG.warn("Put event does not have the Key Info for {}.", (Object)event.getKey());
        }
    }

    @Override
    public void handleDeleteEvent(OMDBUpdateEvent<String, Object> event, String tableName, Map<String, Long> objectCountMap, Map<String, Long> unReplicatedSizeMap, Map<String, Long> replicatedSizeMap) {
        if (event.getValue() != null) {
            OmKeyInfo omKeyInfo = (OmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(this.getTableCountKeyFromTable(tableName), (k, count) -> count > 0L ? count - 1L : 0L);
            unReplicatedSizeMap.computeIfPresent(this.getUnReplicatedSizeKeyFromTable(tableName), (k, size) -> size > omKeyInfo.getDataSize() ? size - omKeyInfo.getDataSize() : 0L);
            replicatedSizeMap.computeIfPresent(this.getReplicatedSizeKeyFromTable(tableName), (k, size) -> size > omKeyInfo.getReplicatedSize() ? size - omKeyInfo.getReplicatedSize() : 0L);
        } else {
            LOG.warn("Delete event does not have the Key Info for {}.", (Object)event.getKey());
        }
    }

    @Override
    public void handleUpdateEvent(OMDBUpdateEvent<String, Object> event, String tableName, Map<String, Long> objectCountMap, Map<String, Long> unReplicatedSizeMap, Map<String, Long> replicatedSizeMap) {
        if (event.getValue() != null) {
            if (event.getOldValue() == null) {
                LOG.warn("Update event does not have the old Key Info for {}.", (Object)event.getKey());
                return;
            }
            OmKeyInfo oldKeyInfo = (OmKeyInfo)event.getOldValue();
            OmKeyInfo newKeyInfo = (OmKeyInfo)event.getValue();
            unReplicatedSizeMap.computeIfPresent(this.getUnReplicatedSizeKeyFromTable(tableName), (k, size) -> size - oldKeyInfo.getDataSize() + newKeyInfo.getDataSize());
            replicatedSizeMap.computeIfPresent(this.getReplicatedSizeKeyFromTable(tableName), (k, size) -> size - oldKeyInfo.getReplicatedSize() + newKeyInfo.getReplicatedSize());
        } else {
            LOG.warn("Update event does not have the Key Info for {}.", (Object)event.getKey());
        }
    }

    @Override
    public Triple<Long, Long, Long> getTableSizeAndCount(TableIterator<String, ? extends Table.KeyValue<String, ?>> iterator) throws IOException {
        long count = 0L;
        long unReplicatedSize = 0L;
        long replicatedSize = 0L;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                if (kv == null || kv.getValue() == null) continue;
                OmKeyInfo omKeyInfo = (OmKeyInfo)kv.getValue();
                unReplicatedSize += omKeyInfo.getDataSize();
                replicatedSize += omKeyInfo.getReplicatedSize();
                ++count;
            }
        }
        return Triple.of((Object)count, (Object)unReplicatedSize, (Object)replicatedSize);
    }
}

