/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTaskDbEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTaskDbEventHandler.class);
    private ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private ReconOMMetadataManager reconOMMetadataManager;

    public NSSummaryTaskDbEventHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconOMMetadataManager = reconOMMetadataManager;
    }

    public ReconNamespaceSummaryManager getReconNamespaceSummaryManager() {
        return this.reconNamespaceSummaryManager;
    }

    public ReconOMMetadataManager getReconOMMetadataManager() {
        return this.reconOMMetadataManager;
    }

    protected void writeNSSummariesToDB(Map<Long, NSSummary> nsSummaryMap) throws IOException {
        try (RDBBatchOperation rdbBatchOperation = new RDBBatchOperation();){
            for (Map.Entry<Long, NSSummary> entry : nsSummaryMap.entrySet()) {
                try {
                    this.reconNamespaceSummaryManager.batchStoreNSSummaries((BatchOperation)rdbBatchOperation, entry.getKey(), entry.getValue());
                }
                catch (IOException e) {
                    LOG.error("Unable to write Namespace Summary data in Recon DB.", (Throwable)e);
                    throw e;
                }
            }
            this.reconNamespaceSummaryManager.commitBatchOperation(rdbBatchOperation);
        }
    }

    protected void handlePutKeyEvent(OmKeyInfo keyInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        int binIndex;
        long parentObjectId = keyInfo.getParentObjectID();
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            nsSummary = new NSSummary();
        }
        int[] fileBucket = nsSummary.getFileSizeBucket();
        nsSummary.setNumOfFiles(nsSummary.getNumOfFiles() + 1);
        nsSummary.setSizeOfFiles(nsSummary.getSizeOfFiles() + keyInfo.getDataSize());
        int n = binIndex = ReconUtils.getFileSizeBinIndex(keyInfo.getDataSize());
        fileBucket[n] = fileBucket[n] + 1;
        nsSummary.setFileSizeBucket(fileBucket);
        nsSummaryMap.put(parentObjectId, nsSummary);
    }

    protected void handlePutDirEvent(OmDirectoryInfo directoryInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        long parentObjectId = directoryInfo.getParentObjectID();
        long objectId = directoryInfo.getObjectID();
        String dirName = directoryInfo.getName();
        NSSummary curNSSummary = nsSummaryMap.get(objectId);
        if (curNSSummary == null) {
            curNSSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        }
        if (curNSSummary == null) {
            curNSSummary = new NSSummary();
        }
        curNSSummary.setDirName(dirName);
        curNSSummary.setParentId(parentObjectId);
        nsSummaryMap.put(objectId, curNSSummary);
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            nsSummary = new NSSummary();
        }
        nsSummary.addChildDir(objectId);
        nsSummaryMap.put(parentObjectId, nsSummary);
    }

    protected void handleDeleteKeyEvent(OmKeyInfo keyInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        long parentObjectId = keyInfo.getParentObjectID();
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            LOG.error("The namespace table is not correctly populated.");
            return;
        }
        int[] fileBucket = nsSummary.getFileSizeBucket();
        int binIndex = ReconUtils.getFileSizeBinIndex(keyInfo.getDataSize());
        nsSummary.setNumOfFiles(nsSummary.getNumOfFiles() - 1);
        nsSummary.setSizeOfFiles(nsSummary.getSizeOfFiles() - keyInfo.getDataSize());
        int n = binIndex;
        fileBucket[n] = fileBucket[n] - 1;
        nsSummary.setFileSizeBucket(fileBucket);
        nsSummaryMap.put(parentObjectId, nsSummary);
    }

    protected void handleDeleteDirEvent(OmDirectoryInfo directoryInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        long parentObjectId = directoryInfo.getParentObjectID();
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            LOG.error("The namespace table is not correctly populated.");
            return;
        }
        nsSummary.removeChildDir(directoryInfo.getObjectID());
        nsSummaryMap.put(parentObjectId, nsSummary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushAndCommitNSToDB(Map<Long, NSSummary> nsSummaryMap) {
        try {
            this.writeNSSummariesToDB(nsSummaryMap);
        }
        catch (IOException e) {
            LOG.error("Unable to write Namespace Summary data in Recon DB.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            nsSummaryMap.clear();
        }
        return true;
    }
}

