/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.security;

import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyPair;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.client.DefaultCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.security.x509.exception.CertificateException;
import org.apache.hadoop.ozone.recon.scm.ReconStorageConfig;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconCertificateClient
extends DefaultCertificateClient {
    private static final Logger LOG = LoggerFactory.getLogger(ReconCertificateClient.class);
    public static final String COMPONENT_NAME = "recon";
    private final String clusterID;
    private final String reconID;

    public ReconCertificateClient(SecurityConfig config, SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient, ReconStorageConfig storage, Consumer<String> saveCertIdCallback, Runnable shutdownCallback) {
        super(config, scmSecurityClient, LOG, storage.getReconCertSerialId(), COMPONENT_NAME, "", saveCertIdCallback, shutdownCallback);
        this.clusterID = storage.getClusterID();
        this.reconID = storage.getReconId();
    }

    public CertificateSignRequest.Builder configureCSRBuilder() throws SCMSecurityException {
        LOG.info("Creating CSR for Recon.");
        try {
            CertificateSignRequest.Builder builder = super.configureCSRBuilder();
            String hostname = InetAddress.getLocalHost().getCanonicalHostName();
            String subject = UserGroupInformation.getCurrentUser().getShortUserName() + "@" + hostname;
            builder.setCA(Boolean.valueOf(false)).setKey(new KeyPair(this.getPublicKey(), this.getPrivateKey())).setConfiguration(this.getSecurityConfig()).setSubject(subject);
            return builder;
        }
        catch (Exception e) {
            LOG.error("Failed to get hostname or current user", (Throwable)e);
            throw new CertificateException("Failed to get hostname or current user", (Throwable)e, CertificateException.ErrorCode.CSR_ERROR);
        }
    }

    protected SCMSecurityProtocolProtos.SCMGetCertResponseProto sign(CertificateSignRequest request) throws IOException {
        HddsProtos.NodeDetailsProto.Builder reconDetailsProtoBuilder = HddsProtos.NodeDetailsProto.newBuilder().setHostName(InetAddress.getLocalHost().getHostName()).setClusterId(this.clusterID).setUuid(this.reconID).setNodeType(HddsProtos.NodeType.RECON);
        SCMSecurityProtocolProtos.SCMGetCertResponseProto response = this.getScmSecureClient().getCertificateChain(reconDetailsProtoBuilder.build(), request.toEncodedFormat());
        return response;
    }

    public Logger getLogger() {
        return LOG;
    }
}

