/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.protocol.VersionResponse;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.RegisteredCommand;
import org.apache.hadoop.ozone.protocol.commands.ReregisterCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.recon.ReconContext;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconNodeManager
extends SCMNodeManager {
    public static final Logger LOG = LoggerFactory.getLogger(ReconNodeManager.class);
    private Table<UUID, DatanodeDetails> nodeDB;
    private ReconContext reconContext;
    private static final Set<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type> ALLOWED_COMMANDS = ImmutableSet.of((Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reregisterCommand);
    private Map<UUID, Long> datanodeHeartbeatMap = new HashMap<UUID, Long>();
    private Map<UUID, DatanodeDetails> inMemDatanodeDetails = new HashMap<UUID, DatanodeDetails>();
    private long reconDatanodeOutdatedTime;
    private static int reconStaleDatanodeMultiplier = 3;
    private static final DatanodeDetails EMPTY_DATANODE_DETAILS = DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).build();

    public ReconNodeManager(OzoneConfiguration conf, SCMStorageConfig scmStorageConfig, EventPublisher eventPublisher, NetworkTopology networkTopology, Table<UUID, DatanodeDetails> nodeDB, HDDSLayoutVersionManager scmLayoutVersionManager) {
        super(conf, scmStorageConfig, eventPublisher, networkTopology, SCMContext.emptyContext(), scmLayoutVersionManager);
        this.reconDatanodeOutdatedTime = (long)reconStaleDatanodeMultiplier * HddsServerUtil.getReconHeartbeatInterval((ConfigurationSource)conf);
        this.nodeDB = nodeDB;
    }

    public ReconNodeManager(OzoneConfiguration conf, SCMStorageConfig scmStorageConfig, EventQueue eventQueue, NetworkTopology clusterMap, Table<UUID, DatanodeDetails> table, HDDSLayoutVersionManager scmLayoutVersionManager, ReconContext reconContext) {
        this(conf, scmStorageConfig, (EventPublisher)eventQueue, clusterMap, table, scmLayoutVersionManager);
        this.reconContext = reconContext;
        this.loadExistingNodes();
    }

    private void loadExistingNodes() {
        try (TableIterator iterator = this.nodeDB.iterator();){
            int nodeCount = 0;
            while (iterator.hasNext()) {
                DatanodeDetails datanodeDetails = (DatanodeDetails)((Table.KeyValue)iterator.next()).getValue();
                this.register(datanodeDetails, null, null, StorageContainerDatanodeProtocolProtos.LayoutVersionProto.newBuilder().setMetadataLayoutVersion(HDDSLayoutVersionManager.maxLayoutVersion()).setSoftwareLayoutVersion(HDDSLayoutVersionManager.maxLayoutVersion()).build());
                ++nodeCount;
            }
            LOG.info("Loaded {} nodes from node DB.", (Object)nodeCount);
        }
        catch (IOException ioEx) {
            LOG.error("Exception while loading existing nodes.", (Throwable)ioEx);
        }
    }

    public VersionResponse getVersion(StorageContainerDatanodeProtocolProtos.SCMVersionRequestProto versionRequest) {
        return VersionResponse.newBuilder().setVersion(0).build();
    }

    public void addNodeToDB(DatanodeDetails datanodeDetails) throws IOException {
        this.nodeDB.put((Object)datanodeDetails.getUuid(), (Object)datanodeDetails);
        LOG.info("Adding new node {} to Node DB.", (Object)datanodeDetails.getUuid());
    }

    public long getLastHeartbeat(DatanodeDetails datanodeDetails) {
        return this.datanodeHeartbeatMap.getOrDefault(datanodeDetails.getUuid(), 0L);
    }

    public String getHostName(DatanodeDetails datanodeDetails) {
        return this.inMemDatanodeDetails.getOrDefault(datanodeDetails.getUuid(), EMPTY_DATANODE_DETAILS).getHostName();
    }

    public String getVersion(DatanodeDetails datanodeDetails) {
        return this.inMemDatanodeDetails.getOrDefault(datanodeDetails.getUuid(), EMPTY_DATANODE_DETAILS).getVersion();
    }

    public long getSetupTime(DatanodeDetails datanodeDetails) {
        return this.inMemDatanodeDetails.getOrDefault(datanodeDetails.getUuid(), EMPTY_DATANODE_DETAILS).getSetupTime();
    }

    public String getRevision(DatanodeDetails datanodeDetails) {
        return this.inMemDatanodeDetails.getOrDefault(datanodeDetails.getUuid(), EMPTY_DATANODE_DETAILS).getRevision();
    }

    public void onMessage(CommandForDatanode commandForDatanode, EventPublisher ignored) {
        StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type cmdType = commandForDatanode.getCommand().getType();
        if (ALLOWED_COMMANDS.contains(cmdType)) {
            super.onMessage(commandForDatanode, ignored);
        } else {
            LOG.debug("Ignoring unsupported command {} for Datanode {}.", (Object)commandForDatanode.getCommand().getType(), (Object)commandForDatanode.getDatanodeId());
        }
    }

    public List<SCMCommand<?>> processHeartbeat(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.CommandQueueReportProto queueReport) {
        ArrayList cmds = new ArrayList();
        long currentTime = Time.now();
        if (this.needUpdate(datanodeDetails, currentTime)) {
            cmds.add((SCMCommand<?>)new ReregisterCommand());
            LOG.info("Sending ReregisterCommand() for " + datanodeDetails.getHostName());
            this.datanodeHeartbeatMap.put(datanodeDetails.getUuid(), Time.now());
            return cmds;
        }
        this.datanodeHeartbeatMap.put(datanodeDetails.getUuid(), Time.now());
        cmds.addAll(super.processHeartbeat(datanodeDetails, queueReport));
        return cmds.stream().filter(c -> ALLOWED_COMMANDS.contains(c.getType())).collect(Collectors.toList());
    }

    protected void updateDatanodeOpState(DatanodeDetails reportedDn) throws NodeNotFoundException {
        super.updateDatanodeOpState(reportedDn);
        super.getNodeStateManager().setNodeOperationalState(reportedDn, reportedDn.getPersistedOpState(), reportedDn.getPersistedOpStateExpiryEpochSec());
    }

    public void refreshAllHealthyDnUsageInfo() {
    }

    public RegisteredCommand register(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport, StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReportsProto, StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutInfo) {
        this.inMemDatanodeDetails.put(datanodeDetails.getUuid(), datanodeDetails);
        if (this.isNodeRegistered(datanodeDetails).booleanValue()) {
            try {
                this.nodeDB.put((Object)datanodeDetails.getUuid(), (Object)datanodeDetails);
                LOG.info("Updating nodeDB for " + datanodeDetails.getHostName());
            }
            catch (IOException e) {
                LOG.error("Can not update node {} to Node DB.", (Object)datanodeDetails.getUuid());
            }
        }
        try {
            RegisteredCommand registeredCommand = super.register(datanodeDetails, nodeReport, pipelineReportsProto, layoutInfo);
            this.reconContext.updateHealthStatus(new AtomicBoolean(true));
            this.reconContext.getErrors().remove((Object)ReconContext.ErrorCode.INVALID_NETWORK_TOPOLOGY);
            return registeredCommand;
        }
        catch (NetworkTopology.InvalidTopologyException invalidTopologyException) {
            LOG.error("InvalidTopologyException error occurred : {}", (Object)invalidTopologyException.getMessage());
            this.reconContext.updateHealthStatus(new AtomicBoolean(false));
            this.reconContext.getErrors().add(ReconContext.ErrorCode.INVALID_NETWORK_TOPOLOGY);
            return RegisteredCommand.newBuilder().setErrorCode(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode.errorNodeNotPermitted).setDatanode(datanodeDetails).setClusterID(this.reconContext.getClusterId()).build();
        }
    }

    public void updateNodeOperationalStateFromScm(HddsProtos.Node scmNode, DatanodeDetails dnDetails) throws NodeNotFoundException {
        NodeStatus nodeStatus = this.getNodeStatus(dnDetails);
        HddsProtos.NodeOperationalState nodeOperationalStateFromScm = scmNode.getNodeOperationalStates(0);
        if (nodeOperationalStateFromScm != nodeStatus.getOperationalState()) {
            LOG.info("Updating Node operational state for {}, in SCM = {}, in Recon = {}", new Object[]{dnDetails.getHostName(), nodeOperationalStateFromScm, nodeStatus.getOperationalState()});
            this.setNodeOperationalState(dnDetails, nodeOperationalStateFromScm);
            DatanodeDetails scmDnd = this.getNodeByUuid(dnDetails.getUuid());
            scmDnd.setPersistedOpState(nodeOperationalStateFromScm);
        }
    }

    private boolean needUpdate(DatanodeDetails datanodeDetails, long currentTime) {
        return currentTime - this.getLastHeartbeat(datanodeDetails) >= this.reconDatanodeOutdatedTime;
    }

    public void reinitialize(Table<UUID, DatanodeDetails> nodeTable) {
        this.nodeDB = nodeTable;
        this.loadExistingNodes();
    }

    @VisibleForTesting
    public long getNodeDBKeyCount() throws IOException {
        long nodeCount = 0L;
        try (TableIterator iterator = this.nodeDB.iterator();){
            while (iterator.hasNext()) {
                iterator.next();
                ++nodeCount;
            }
            long l = nodeCount;
            return l;
        }
    }

    public void removeNode(DatanodeDetails datanodeDetails) throws NodeNotFoundException, IOException {
        try {
            super.removeNode(datanodeDetails);
            this.nodeDB.delete((Object)datanodeDetails.getUuid());
        }
        catch (IOException ioException) {
            LOG.error("Node {} deletion fails from Node DB.", (Object)datanodeDetails.getUuid());
            throw ioException;
        }
        this.datanodeHeartbeatMap.remove(datanodeDetails.getUuid());
        this.inMemDatanodeDetails.remove(datanodeDetails.getUuid());
        LOG.info("Removed existing node {} from Node DB and NodeManager data structures in memory ", (Object)datanodeDetails.getUuid());
    }

    @VisibleForTesting
    public ReconContext getReconContext() {
        return this.reconContext;
    }

    protected void sendFinalizeToDatanodeIfNeeded(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutVersionReport) {
        int scmSlv = this.getLayoutVersionManager().getSoftwareLayoutVersion();
        int scmMlv = this.getLayoutVersionManager().getMetadataLayoutVersion();
        int dnSlv = layoutVersionReport.getSoftwareLayoutVersion();
        int dnMlv = layoutVersionReport.getMetadataLayoutVersion();
        if (dnSlv > scmSlv) {
            LOG.error("Invalid data node reporting to Recon : {}. DataNode SoftwareLayoutVersion = {}, Recon/SCM SoftwareLayoutVersion = {}", new Object[]{datanodeDetails.getHostName(), dnSlv, scmSlv});
        }
        if (scmMlv == scmSlv && dnMlv < scmMlv && LOG.isDebugEnabled()) {
            LOG.debug("Data node {} reports a lower MLV than Recon DataNode MetadataLayoutVersion = {}, Recon/SCM MetadataLayoutVersion = {}. SCM needs to finalize this DN", new Object[]{datanodeDetails.getHostName(), dnMlv, scmMlv});
        }
    }
}

