/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.MessageLite;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class KeyEntityInfoProtoWrapper {
    private final OzoneManagerProtocolProtos.KeyInfo keyInfoProto;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="replicatedSize")
    private final long replicatedSize;
    @JsonProperty(value="replicationInfo")
    private final ReplicationConfig replicationConfig;

    public static Codec<KeyEntityInfoProtoWrapper> getCodec() {
        return new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.KeyInfo.getDefaultInstance()), KeyEntityInfoProtoWrapper::getFromProtobuf, KeyEntityInfoProtoWrapper::toProtobuf, KeyEntityInfoProtoWrapper.class);
    }

    private KeyEntityInfoProtoWrapper(OzoneManagerProtocolProtos.KeyInfo proto) {
        this.keyInfoProto = proto;
        this.replicationConfig = ReplicationConfig.fromProto((HddsProtos.ReplicationType)proto.getType(), (HddsProtos.ReplicationFactor)proto.getFactor(), (HddsProtos.ECReplicationConfig)proto.getEcReplicationConfig());
        this.replicatedSize = QuotaUtil.getReplicatedSize((long)this.getSize(), (ReplicationConfig)this.getReplicationConfig());
    }

    public static KeyEntityInfoProtoWrapper getFromProtobuf(OzoneManagerProtocolProtos.KeyInfo keyInfo) {
        return new KeyEntityInfoProtoWrapper(keyInfo);
    }

    public OzoneManagerProtocolProtos.KeyInfo toProtobuf() {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    @JsonProperty(value="key")
    public String getKey() {
        if (this.key == null) {
            throw new IllegalStateException("Key must be set to correctly serialize this object.");
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="path")
    public String getPath() {
        if (this.path == null) {
            throw new IllegalStateException("Path must be set to correctly serialize this object.");
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="size")
    public long getSize() {
        return this.keyInfoProto.getDataSize();
    }

    @JsonProperty(value="replicatedSize")
    public long getReplicatedSize() {
        return this.replicatedSize;
    }

    @JsonProperty(value="replicationInfo")
    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    @JsonProperty(value="creationTime")
    public long getCreationTime() {
        return this.keyInfoProto.getCreationTime();
    }

    @JsonProperty(value="modificationTime")
    public long getModificationTime() {
        return this.keyInfoProto.getModificationTime();
    }

    @JsonProperty(value="isKey")
    public boolean getIsKey() {
        return this.keyInfoProto.getIsFile();
    }

    public long getParentId() {
        return this.keyInfoProto.getParentID();
    }

    public String getVolumeName() {
        return this.keyInfoProto.getVolumeName();
    }

    public String getBucketName() {
        return this.keyInfoProto.getBucketName();
    }

    public String getKeyName() {
        return this.keyInfoProto.getKeyName();
    }
}

