/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.ozone.recon.upgrade.ReconLayoutFeature;
import org.apache.ozone.recon.schema.ReconSchemaDefinition;
import org.apache.ozone.recon.schema.SchemaVersionTableDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconSchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconSchemaManager.class);
    private Set<ReconSchemaDefinition> reconSchemaDefinitions = new HashSet<ReconSchemaDefinition>();

    @Inject
    public ReconSchemaManager(Set<ReconSchemaDefinition> reconSchemaDefinitions) {
        this.reconSchemaDefinitions.addAll(reconSchemaDefinitions);
    }

    @VisibleForTesting
    public void createReconSchema() {
        int latestSLV = this.calculateLatestSLV();
        try {
            this.reconSchemaDefinitions.stream().filter(SchemaVersionTableDefinition.class::isInstance).findFirst().ifPresent(schemaDefinition -> {
                SchemaVersionTableDefinition schemaVersionTable = (SchemaVersionTableDefinition)schemaDefinition;
                schemaVersionTable.setLatestSLV(latestSLV);
                try {
                    schemaVersionTable.initializeSchema();
                }
                catch (SQLException e) {
                    LOG.error("Error initializing SchemaVersionTableDefinition.", (Throwable)e);
                }
            });
            this.reconSchemaDefinitions.stream().filter(definition -> !(definition instanceof SchemaVersionTableDefinition)).forEach(definition -> {
                try {
                    definition.initializeSchema();
                }
                catch (SQLException e) {
                    LOG.error("Error initializing schema: {}.", (Object)definition.getClass().getSimpleName(), (Object)e);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error creating Recon schema.", (Throwable)e);
        }
    }

    private int calculateLatestSLV() {
        return ReconLayoutFeature.determineSLV();
    }
}

