/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.spi.MetricsServiceProvider;
import org.apache.hadoop.ozone.recon.spi.impl.PrometheusServiceProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetricsServiceProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsServiceProviderFactory.class);
    private OzoneConfiguration configuration;
    private ReconUtils reconUtils;

    @Inject
    public MetricsServiceProviderFactory(OzoneConfiguration configuration, ReconUtils reconUtils) {
        this.configuration = configuration;
        this.reconUtils = reconUtils;
    }

    public MetricsServiceProvider getMetricsServiceProvider() {
        String prometheusEndpoint = this.getPrometheusEndpoint();
        if (StringUtils.isNotEmpty((CharSequence)prometheusEndpoint)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Choosing Prometheus as Metrics service provider with configured endpoint: %s", prometheusEndpoint));
            }
            return new PrometheusServiceProviderImpl(this.configuration, this.reconUtils);
        }
        return null;
    }

    private String getPrometheusEndpoint() {
        String endpoint = this.configuration.getTrimmed("ozone.recon.prometheus.http.endpoint");
        if (endpoint != null && endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        return endpoint;
    }
}

