/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import java.io.Closeable;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.hadoop.hdds.utils.NativeLibraryLoader;
import org.apache.hadoop.hdds.utils.NativeLibraryNotLoadedException;
import org.apache.hadoop.hdds.utils.db.managed.ManagedOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRawSSTFileIterator;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSlice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedRawSSTFileReader<T>
implements Closeable {
    private final String fileName;
    private final long nativeHandle;
    private static final Logger LOG = LoggerFactory.getLogger(ManagedRawSSTFileReader.class);

    public static boolean loadLibrary() throws NativeLibraryNotLoadedException {
        ManagedRocksObjectUtils.loadRocksDBLibrary();
        if (!NativeLibraryLoader.getInstance().loadLibrary("ozone_rocksdb_tools", Arrays.asList(ManagedRocksObjectUtils.getRocksDBLibFileName()))) {
            throw new NativeLibraryNotLoadedException("ozone_rocksdb_tools");
        }
        return true;
    }

    public ManagedRawSSTFileReader(ManagedOptions options, String fileName, int readAheadSize) {
        this.fileName = fileName;
        this.nativeHandle = this.newRawSSTFileReader(options.getNativeHandle(), fileName, readAheadSize);
    }

    public ManagedRawSSTFileIterator<T> newIterator(Function<ManagedRawSSTFileIterator.KeyValue, T> transformerFunction, ManagedSlice fromSlice, ManagedSlice toSlice) {
        long fromNativeHandle = fromSlice == null ? 0L : fromSlice.getNativeHandle();
        long toNativeHandle = toSlice == null ? 0L : toSlice.getNativeHandle();
        LOG.info("Iterating SST file: {} with native lib. LowerBound: {}, UpperBound: {}", new Object[]{this.fileName, fromSlice, toSlice});
        return new ManagedRawSSTFileIterator<T>(this.newIterator(this.nativeHandle, fromSlice != null, fromNativeHandle, toSlice != null, toNativeHandle), transformerFunction);
    }

    private native long newRawSSTFileReader(long var1, String var3, int var4);

    private native long newIterator(long var1, boolean var3, long var4, boolean var6, long var7);

    private native void disposeInternal(long var1);

    @Override
    public void close() {
        this.disposeInternal(this.nativeHandle);
    }
}

