/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jooq.tools.json.ContainerFactory;
import org.jooq.tools.json.JSONParser;
import org.jooq.tools.json.ParseException;

final class JSONReader
implements Closeable {
    private final BufferedReader br;
    private final JSONParser parser;
    private String[] fieldNames;
    private Map<String, Integer> fieldIndexes;
    private List<String[]> records;

    JSONReader(Reader reader) {
        this.br = new BufferedReader(reader);
        this.parser = new JSONParser();
    }

    final List<String[]> readAll() throws IOException {
        if (this.records == null) {
            try {
                LinkedHashMap<String, LinkedList<?>> jsonRoot = this.getJsonRoot();
                this.readFields(jsonRoot);
                this.readRecords(jsonRoot);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.records;
    }

    final String[] getFields() throws IOException {
        if (this.fieldNames == null) {
            this.readAll();
        }
        return this.fieldNames;
    }

    @Override
    public final void close() throws IOException {
        this.br.close();
    }

    private final void readRecords(LinkedHashMap<String, LinkedList<?>> jsonRoot) {
        LinkedList<?> rootRecords = jsonRoot.get("records");
        this.records = new ArrayList<String[]>(rootRecords.size());
        for (Object record : rootRecords) {
            String[] v = new String[this.fieldNames.length];
            int i = 0;
            if (record instanceof LinkedList) {
                for (Object e : (LinkedList)record) {
                    v[i++] = e == null ? null : String.valueOf(e);
                }
            } else if (record instanceof LinkedHashMap) {
                for (Map.Entry entry : ((LinkedHashMap)record).entrySet()) {
                    v[this.fieldIndexes.get(entry.getKey()).intValue()] = entry.getValue() == null ? null : String.valueOf(entry.getValue());
                }
            } else {
                throw new IllegalArgumentException("Ill formed JSON : " + jsonRoot);
            }
            this.records.add(v);
        }
    }

    private LinkedHashMap<String, LinkedList<?>> getJsonRoot() throws IOException, ParseException {
        Object parse = this.parser.parse((Reader)this.br, new ContainerFactory(){

            @Override
            public LinkedHashMap<String, Object> createObjectContainer() {
                return new LinkedHashMap<String, Object>();
            }

            @Override
            public List<Object> createArrayContainer() {
                return new LinkedList<Object>();
            }
        });
        return (LinkedHashMap)parse;
    }

    private final void readFields(LinkedHashMap<String, LinkedList<?>> jsonRoot) {
        LinkedList<?> fieldEntries = jsonRoot.get("fields");
        this.fieldNames = new String[fieldEntries.size()];
        this.fieldIndexes = new HashMap<String, Integer>();
        int i = 0;
        for (LinkedHashMap key : fieldEntries) {
            String name;
            this.fieldNames[i] = name = (String)key.get("name");
            this.fieldIndexes.put(name, i);
            ++i;
        }
    }
}

