/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.cache;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheResult;
import org.apache.hadoop.hdds.utils.db.cache.CacheStats;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class TableNoCache<KEY, VALUE>
implements TableCache<KEY, VALUE> {
    public static final CacheStats EMPTY_STAT = new CacheStats(0L, 0L, 0L);
    private static final TableCache<?, ?> NO_CACHE_INSTANCE = new TableNoCache();

    public static <K, V> TableCache<K, V> instance() {
        return NO_CACHE_INSTANCE;
    }

    private TableNoCache() {
    }

    @Override
    public CacheValue<VALUE> get(CacheKey<KEY> cachekey) {
        return null;
    }

    @Override
    public void loadInitial(CacheKey<KEY> key, CacheValue<VALUE> value) {
    }

    @Override
    public void put(CacheKey<KEY> cacheKey, CacheValue<VALUE> value) {
    }

    @Override
    public void cleanup(List<Long> epochs) {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    @VisibleForTesting
    public void evictCache(List<Long> epochs) {
    }

    @Override
    public CacheResult<VALUE> lookup(CacheKey<KEY> cachekey) {
        return MAY_EXIST;
    }

    @Override
    @VisibleForTesting
    public NavigableMap<Long, Set<CacheKey<KEY>>> getEpochEntries() {
        return Collections.emptyNavigableMap();
    }

    @Override
    public CacheStats getStats() {
        return EMPTY_STAT;
    }

    @Override
    public TableCache.CacheType getCacheType() {
        return TableCache.CacheType.NO_CACHE;
    }
}

