/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsUtil {
    private static final String ANNOTATIONS = "annotations";
    private static final String ANNOTATION_DATA = "annotationData";
    private static final Class<? extends Annotation> ANNOTATION_TO_ALTER = Metrics.class;
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUtil.class);

    private MetricsUtil() {
    }

    public static <T> void registerDynamic(T source, String name, String desc, String context) {
        MetricsUtil.updateAnnotation(source.getClass(), name, desc, context);
        DefaultMetricsSystem.instance().register(name, desc, source);
    }

    private static void updateAnnotation(Class clz, final String name, final String desc, final String context) {
        try {
            Metrics annotationValue = new Metrics(){

                public Class<? extends Annotation> annotationType() {
                    return ANNOTATION_TO_ALTER;
                }

                public String name() {
                    return name;
                }

                public String about() {
                    return desc;
                }

                public String context() {
                    return context;
                }
            };
            Method method = clz.getClass().getDeclaredMethod(ANNOTATION_DATA, null);
            method.setAccessible(true);
            Object annotationData = method.invoke((Object)clz, new Object[0]);
            Field annotations = annotationData.getClass().getDeclaredField(ANNOTATIONS);
            annotations.setAccessible(true);
            Map map = (Map)annotations.get(annotationData);
            map.put(ANNOTATION_TO_ALTER, annotationValue);
        }
        catch (Exception e) {
            LOG.error("Update Metrics annotation failed. ", (Throwable)e);
        }
    }
}

