/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface CollectionUtils {
    public static <KEY, VALUE> Map<KEY, VALUE> newUnmodifiableMap(List<VALUE> values, Function<VALUE, KEY> getKey, Map<KEY, VALUE> existing) {
        HashMap<KEY, VALUE> map = new HashMap<KEY, VALUE>(existing);
        for (VALUE v : values) {
            KEY key = getKey.apply(v);
            VALUE previous = map.put(key, v);
            if (previous == null) continue;
            throw new IllegalArgumentException("Already exists: " + key + ", previous " + previous.getClass());
        }
        return Collections.unmodifiableMap(map);
    }

    public static <KEY, VALUE> Map<KEY, List<VALUE>> newUnmodifiableMultiMap(List<VALUE> values, Function<VALUE, KEY> getKey) {
        HashMap<Object, List> map = new HashMap<Object, List>();
        for (VALUE v : values) {
            KEY key = getKey.apply(v);
            map.computeIfAbsent(key, k -> new ArrayList()).add(v);
        }
        return Collections.unmodifiableMap(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList((List)e.getValue()))));
    }

    public static <T> Iterator<T> newIterator(Collection<List<T>> values) {
        final Iterator<List<T>> listIterator = values.iterator();
        return new Iterator<T>(){
            private Iterator<T> i = Collections.emptyIterator();

            private Iterator<T> nextIterator() {
                if (this.i.hasNext()) {
                    return this.i;
                }
                while (listIterator.hasNext()) {
                    this.i = ((List)listIterator.next()).iterator();
                    if (!this.i.hasNext()) continue;
                    return this.i;
                }
                return Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                return this.nextIterator().hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <T extends Comparable<T>> List<T> findTopN(Iterable<T> input, int n) {
        return CollectionUtils.findTopN(input, n, (? super T any) -> true);
    }

    public static <T extends Comparable<T>> List<T> findTopN(Iterable<T> input, int n, Predicate<? super T> filter) {
        return CollectionUtils.findTopN(input, n, Comparator.naturalOrder(), filter);
    }

    public static <T> List<T> findTopN(Iterable<T> input, int n, Comparator<T> comparator) {
        return CollectionUtils.findTopN(input, n, comparator, any -> true);
    }

    public static <T> List<T> findTopN(Iterable<T> input, int n, Comparator<T> comparator, Predicate<? super T> filter) {
        PriorityQueue<T> heap = new PriorityQueue<T>(comparator);
        for (T item : input) {
            if (!filter.test(item)) continue;
            heap.add(item);
            if (heap.size() <= n) continue;
            heap.poll();
        }
        LinkedList<T> result = new LinkedList<T>();
        while (!heap.isEmpty()) {
            result.addFirst(heap.poll());
        }
        return result;
    }
}

