/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.freon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FakeClusterTopology {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeClusterTopology.class);
    public static final FakeClusterTopology INSTANCE = FakeClusterTopology.newFakeClusterTopology();
    private final List<HddsProtos.DatanodeDetailsProto> datanodes;
    private final List<HddsProtos.Pipeline> pipelines;
    private final Random random = new Random();

    private static FakeClusterTopology newFakeClusterTopology() {
        int nodeCount = 9;
        ArrayList<HddsProtos.DatanodeDetailsProto> datanodes = new ArrayList<HddsProtos.DatanodeDetailsProto>(9);
        ArrayList<HddsProtos.Pipeline> pipelines = new ArrayList<HddsProtos.Pipeline>(3);
        try {
            for (int i = 0; i < 9; ++i) {
                datanodes.add(FakeClusterTopology.createDatanode());
                if ((i + 1) % 3 != 0) continue;
                pipelines.add(HddsProtos.Pipeline.newBuilder().setId(PipelineID.randomId().getProtobuf()).setFactor(HddsProtos.ReplicationFactor.THREE).setType(HddsProtos.ReplicationType.RATIS).addMembers((HddsProtos.DatanodeDetailsProto)datanodes.get(i - 2)).addMembers((HddsProtos.DatanodeDetailsProto)datanodes.get(i - 1)).addMembers((HddsProtos.DatanodeDetailsProto)datanodes.get(i)).build());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Can't initialize FakeClusterTopology", (Throwable)ex);
        }
        return new FakeClusterTopology(datanodes, pipelines);
    }

    private FakeClusterTopology(List<HddsProtos.DatanodeDetailsProto> datanodes, List<HddsProtos.Pipeline> pipelines) {
        this.datanodes = Collections.unmodifiableList(datanodes);
        this.pipelines = Collections.unmodifiableList(pipelines);
    }

    private static HddsProtos.DatanodeDetailsProto createDatanode() {
        return HddsProtos.DatanodeDetailsProto.newBuilder().setUuid(UUID.randomUUID().toString()).setHostName("localhost").setIpAddress("127.0.0.1").addPorts(HddsProtos.Port.newBuilder().setName("RATIS").setValue(1234)).build();
    }

    public HddsProtos.Pipeline getRandomPipeline() {
        return this.pipelines.get(this.random.nextInt(this.pipelines.size()));
    }

    public Iterable<HddsProtos.DatanodeDetailsProto> getAllDatanodes() {
        return this.datanodes;
    }
}

