/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.ContainerSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.DataNodeSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.HealthyPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.OneReplicaPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.server.events.EventQueue;

public final class SafeModeRuleFactory {
    private final ConfigurationSource config;
    private final SCMContext scmContext;
    private final EventQueue eventQueue;
    private final SCMSafeModeManager safeModeManager;
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;
    private final List<SafeModeExitRule<?>> safeModeRules;
    private final List<SafeModeExitRule<?>> preCheckRules;
    private static SafeModeRuleFactory instance;

    private SafeModeRuleFactory(ConfigurationSource config, SCMContext scmContext, EventQueue eventQueue, SCMSafeModeManager safeModeManager, PipelineManager pipelineManager, ContainerManager containerManager) {
        this.config = config;
        this.scmContext = scmContext;
        this.eventQueue = eventQueue;
        this.safeModeManager = safeModeManager;
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.safeModeRules = new ArrayList();
        this.preCheckRules = new ArrayList();
        this.loadRules();
    }

    private void loadRules() {
        ContainerSafeModeRule containerRule = new ContainerSafeModeRule(this.eventQueue, this.config, this.containerManager, this.safeModeManager);
        DataNodeSafeModeRule datanodeRule = new DataNodeSafeModeRule(this.eventQueue, this.config, this.safeModeManager);
        this.safeModeRules.add(containerRule);
        this.safeModeRules.add(datanodeRule);
        this.preCheckRules.add(datanodeRule);
        if (this.config.getBoolean("hdds.scm.safemode.pipeline-availability.check", true) && this.pipelineManager != null) {
            this.safeModeRules.add(new HealthyPipelineSafeModeRule(this.eventQueue, this.pipelineManager, this.safeModeManager, this.config, this.scmContext));
            this.safeModeRules.add(new OneReplicaPipelineSafeModeRule(this.eventQueue, this.pipelineManager, this.safeModeManager, this.config));
        }
    }

    public static synchronized SafeModeRuleFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("SafeModeRuleFactory not initialized, call initialize method before getInstance.");
    }

    public static synchronized void initialize(ConfigurationSource config, SCMContext scmContext, EventQueue eventQueue, SCMSafeModeManager safeModeManager, PipelineManager pipelineManager, ContainerManager containerManager) {
        instance = new SafeModeRuleFactory(config, scmContext, eventQueue, safeModeManager, pipelineManager, containerManager);
    }

    public List<SafeModeExitRule<?>> getSafeModeRules() {
        return this.safeModeRules;
    }

    public List<SafeModeExitRule<?>> getPreCheckRules() {
        return this.preCheckRules;
    }
}

