/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeAlreadyExistsException;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;

public class NodeStateMap {
    private final Map<DatanodeID, DatanodeInfo> nodeMap = new HashMap<DatanodeID, DatanodeInfo>();
    private final Map<DatanodeID, Set<ContainerID>> nodeToContainer = new HashMap<DatanodeID, Set<ContainerID>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(DatanodeDetails datanodeDetails, NodeStatus nodeStatus, StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutInfo) throws NodeAlreadyExistsException {
        this.lock.writeLock().lock();
        try {
            DatanodeID id = datanodeDetails.getID();
            if (this.nodeMap.containsKey(id)) {
                throw new NodeAlreadyExistsException("Node UUID: " + id);
            }
            this.nodeMap.put(id, new DatanodeInfo(datanodeDetails, nodeStatus, layoutInfo));
            this.nodeToContainer.put(id, new HashSet());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeNode(DatanodeID datanodeID) {
        this.lock.writeLock().lock();
        try {
            this.nodeMap.remove(datanodeID);
            this.nodeToContainer.remove(datanodeID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNode(DatanodeDetails datanodeDetails, NodeStatus nodeStatus, StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutInfo) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            DatanodeID id = datanodeDetails.getID();
            if (!this.nodeMap.containsKey(id)) {
                throw new NodeNotFoundException(id);
            }
            this.nodeMap.put(id, new DatanodeInfo(datanodeDetails, nodeStatus, layoutInfo));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus updateNodeHealthState(DatanodeID nodeId, HddsProtos.NodeState newHealth) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            DatanodeInfo dn = this.getNodeInfoUnsafe(nodeId);
            NodeStatus oldStatus = dn.getNodeStatus();
            NodeStatus newStatus = new NodeStatus(oldStatus.getOperationalState(), newHealth);
            dn.setNodeStatus(newStatus);
            NodeStatus nodeStatus = newStatus;
            return nodeStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus updateNodeOperationalState(DatanodeID nodeId, HddsProtos.NodeOperationalState newOpState, long opStateExpiryEpochSeconds) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            DatanodeInfo dn = this.getNodeInfoUnsafe(nodeId);
            NodeStatus oldStatus = dn.getNodeStatus();
            NodeStatus newStatus = new NodeStatus(newOpState, oldStatus.getHealth(), opStateExpiryEpochSeconds);
            dn.setNodeStatus(newStatus);
            NodeStatus nodeStatus = newStatus;
            return nodeStatus;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public DatanodeInfo getNodeInfo(DatanodeID datanodeID) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            DatanodeInfo datanodeInfo = this.getNodeInfoUnsafe(datanodeID);
            return datanodeInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getNodeCount() {
        this.lock.readLock().lock();
        try {
            int n = this.nodeMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<DatanodeInfo> getAllDatanodeInfos() {
        try {
            this.lock.readLock().lock();
            ArrayList<DatanodeInfo> arrayList = new ArrayList<DatanodeInfo>(this.nodeMap.values());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<DatanodeInfo> getDatanodeInfos(NodeStatus status) {
        return this.filterNodes(NodeStateMap.matching(status));
    }

    public List<DatanodeInfo> getDatanodeInfos(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        return this.filterNodes(opState, health);
    }

    public int getNodeCount(NodeStatus state) {
        return this.getDatanodeInfos(state).size();
    }

    public int getNodeCount(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        return this.filterNodes(opState, health).size();
    }

    public int getTotalNodeCount() {
        this.lock.readLock().lock();
        try {
            int n = this.nodeMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public NodeStatus getNodeStatus(DatanodeID datanodeID) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            NodeStatus nodeStatus = this.getNodeInfoUnsafe(datanodeID).getNodeStatus();
            return nodeStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addContainer(DatanodeID datanodeID, ContainerID containerId) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.getExisting(datanodeID).add(containerId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setContainers(DatanodeID id, Set<ContainerID> containers) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.getExisting(id);
            this.nodeToContainer.put(id, containers);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<ContainerID> getContainers(DatanodeID id) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            HashSet<ContainerID> hashSet = new HashSet<ContainerID>(this.getExisting(id));
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getContainerCount(DatanodeID datanodeID) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            int n = this.getExisting(datanodeID).size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void removeContainer(DatanodeID datanodeID, ContainerID containerID) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            this.getExisting(datanodeID).remove(containerID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Total number of nodes: ").append(this.getTotalNodeCount());
        return builder.toString();
    }

    private Set<ContainerID> getExisting(DatanodeID id) throws NodeNotFoundException {
        Set<ContainerID> containers = this.nodeToContainer.get(id);
        if (containers == null) {
            throw new NodeNotFoundException(id);
        }
        return containers;
    }

    private List<DatanodeInfo> filterNodes(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState health) {
        if (opState != null && health != null) {
            return this.filterNodes(NodeStateMap.matching(new NodeStatus(opState, health)));
        }
        if (opState != null) {
            return this.filterNodes(NodeStateMap.matching(opState));
        }
        if (health != null) {
            return this.filterNodes(NodeStateMap.matching(health));
        }
        return this.getAllDatanodeInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DatanodeInfo> filterNodes(Predicate<DatanodeInfo> filter) {
        LinkedList<DatanodeInfo> result = new LinkedList<DatanodeInfo>();
        this.lock.readLock().lock();
        try {
            for (DatanodeInfo dn : this.nodeMap.values()) {
                if (!filter.test(dn)) continue;
                result.add(dn);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    @Nonnull
    private DatanodeInfo getNodeInfoUnsafe(@Nonnull DatanodeID id) throws NodeNotFoundException {
        DatanodeInfo info = this.nodeMap.get(id);
        if (info == null) {
            throw new NodeNotFoundException(id);
        }
        return info;
    }

    private static Predicate<DatanodeInfo> matching(NodeStatus status) {
        return dn -> status.equals(dn.getNodeStatus());
    }

    private static Predicate<DatanodeInfo> matching(HddsProtos.NodeOperationalState state) {
        return dn -> state.equals((Object)dn.getNodeStatus().getOperationalState());
    }

    private static Predicate<DatanodeInfo> matching(HddsProtos.NodeState health) {
        return dn -> health.equals((Object)dn.getNodeStatus().getHealth());
    }
}

