/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.MoveDataNodePair;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMMetadataStoreImpl
implements SCMMetadataStore {
    private Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTable;
    private Table<BigInteger, X509Certificate> validCertsTable;
    private Table<BigInteger, X509Certificate> validSCMCertsTable;
    private Table<ContainerID, ContainerInfo> containerTable;
    private Table<PipelineID, Pipeline> pipelineTable;
    private Table<String, TransactionInfo> transactionInfoTable;
    private Table<String, Long> sequenceIdTable;
    private Table<ContainerID, MoveDataNodePair> moveTable;
    private Table<String, String> metaTable;
    private Table<String, ByteString> statefulServiceConfigTable;
    private static final Logger LOG = LoggerFactory.getLogger(SCMMetadataStoreImpl.class);
    private DBStore store;
    private final OzoneConfiguration configuration;
    private Map<String, Table<?, ?>> tableMap = new ConcurrentHashMap();

    public SCMMetadataStoreImpl(OzoneConfiguration config) throws IOException {
        this.configuration = config;
        this.start(this.configuration);
    }

    public void start(OzoneConfiguration config) throws IOException {
        if (this.store == null) {
            SCMDBDefinition scmdbDefinition = SCMDBDefinition.get();
            File metaDir = HAUtils.getMetaDir((DBDefinition)scmdbDefinition, (OzoneConfiguration)this.configuration);
            File markerFile = new File(metaDir, "dbInconsistentMarker");
            if (markerFile.exists()) {
                LOG.error("File {} marks that SCM DB is in an inconsistent state.", (Object)markerFile);
                String errorMsg = "Cannot load SCM DB as it is in an inconsistent state.";
                ExitUtils.terminate((int)1, (String)errorMsg, (Logger)LOG);
            }
            this.store = DBStoreBuilder.createDBStore((ConfigurationSource)config, (DBDefinition)scmdbDefinition);
            this.deletedBlocksTable = SCMDBDefinition.DELETED_BLOCKS.getTable(this.store);
            this.checkAndPopulateTable(this.deletedBlocksTable, SCMDBDefinition.DELETED_BLOCKS.getName());
            this.validCertsTable = SCMDBDefinition.VALID_CERTS.getTable(this.store);
            this.checkAndPopulateTable(this.validCertsTable, SCMDBDefinition.VALID_CERTS.getName());
            this.validSCMCertsTable = SCMDBDefinition.VALID_SCM_CERTS.getTable(this.store);
            this.checkAndPopulateTable(this.validSCMCertsTable, SCMDBDefinition.VALID_SCM_CERTS.getName());
            this.pipelineTable = SCMDBDefinition.PIPELINES.getTable(this.store);
            this.checkAndPopulateTable(this.pipelineTable, SCMDBDefinition.PIPELINES.getName());
            this.containerTable = SCMDBDefinition.CONTAINERS.getTable(this.store);
            this.checkAndPopulateTable(this.containerTable, SCMDBDefinition.CONTAINERS.getName());
            this.transactionInfoTable = SCMDBDefinition.TRANSACTIONINFO.getTable(this.store);
            this.checkAndPopulateTable(this.transactionInfoTable, SCMDBDefinition.TRANSACTIONINFO.getName());
            this.sequenceIdTable = SCMDBDefinition.SEQUENCE_ID.getTable(this.store);
            this.checkAndPopulateTable(this.sequenceIdTable, SCMDBDefinition.SEQUENCE_ID.getName());
            this.moveTable = SCMDBDefinition.MOVE.getTable(this.store);
            this.checkAndPopulateTable(this.moveTable, SCMDBDefinition.MOVE.getName());
            this.metaTable = SCMDBDefinition.META.getTable(this.store);
            this.checkAndPopulateTable(this.metaTable, SCMDBDefinition.META.getName());
            this.statefulServiceConfigTable = SCMDBDefinition.STATEFUL_SERVICE_CONFIG.getTable(this.store);
            this.checkAndPopulateTable(this.statefulServiceConfigTable, SCMDBDefinition.STATEFUL_SERVICE_CONFIG.getName());
        }
    }

    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    public DBStore getStore() {
        return this.store;
    }

    public Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getDeletedBlocksTXTable() {
        return this.deletedBlocksTable;
    }

    public Table<BigInteger, X509Certificate> getValidCertsTable() {
        return this.validCertsTable;
    }

    public Table<BigInteger, X509Certificate> getValidSCMCertsTable() {
        return this.validSCMCertsTable;
    }

    public Table<PipelineID, Pipeline> getPipelineTable() {
        return this.pipelineTable;
    }

    public Table<String, TransactionInfo> getTransactionInfoTable() {
        return this.transactionInfoTable;
    }

    public BatchOperationHandler getBatchHandler() {
        return this.store;
    }

    public Table<ContainerID, ContainerInfo> getContainerTable() {
        return this.containerTable;
    }

    public Table<String, Long> getSequenceIdTable() {
        return this.sequenceIdTable;
    }

    public Table<ContainerID, MoveDataNodePair> getMoveTable() {
        return this.moveTable;
    }

    public Table<String, String> getMetaTable() {
        return this.metaTable;
    }

    public Table<String, ByteString> getStatefulServiceConfigTable() {
        return this.statefulServiceConfigTable;
    }

    private void checkAndPopulateTable(Table table, String name) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logs for more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
        this.tableMap.put(name, table);
    }

    Map<String, Table<?, ?>> getTableMap() {
        return this.tableMap;
    }
}

