/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.ReflectionUtil;
import org.apache.hadoop.hdds.scm.ha.io.CodecFactory;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;

public final class SCMRatisResponse {
    private final boolean success;
    private final Object result;
    private final Exception exception;

    private SCMRatisResponse() {
        this(true, null, null);
    }

    private SCMRatisResponse(Object result) {
        this(true, result, null);
    }

    private SCMRatisResponse(Exception exception) {
        this(false, null, exception);
    }

    private SCMRatisResponse(boolean success, Object result, Exception exception) {
        this.success = success;
        this.result = result;
        this.exception = exception;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Object getResult() {
        return this.result;
    }

    public Exception getException() {
        return this.exception;
    }

    public static Message encode(Object result) throws InvalidProtocolBufferException {
        if (result == null) {
            return Message.EMPTY;
        }
        Class<?> type = result.getClass();
        SCMRatisProtocol.SCMRatisResponseProto response = SCMRatisProtocol.SCMRatisResponseProto.newBuilder().setType(type.getName()).setValue(CodecFactory.getCodec(type).serialize(result)).build();
        return Message.valueOf((ByteString)UnsafeByteOperations.unsafeWrap((ByteBuffer)response.toByteString().asReadOnlyByteBuffer()));
    }

    public static SCMRatisResponse decode(RaftClientReply reply) throws InvalidProtocolBufferException {
        if (!reply.isSuccess()) {
            return new SCMRatisResponse((Exception)reply.getException());
        }
        ByteString response = reply.getMessage().getContent();
        if (response.isEmpty()) {
            return new SCMRatisResponse();
        }
        SCMRatisProtocol.SCMRatisResponseProto responseProto = SCMRatisProtocol.SCMRatisResponseProto.parseFrom((byte[])response.toByteArray());
        try {
            Class<?> type = ReflectionUtil.getClass(responseProto.getType());
            return new SCMRatisResponse(CodecFactory.getCodec(type).deserialize(type, responseProto.getValue()));
        }
        catch (ClassNotFoundException e) {
            throw new InvalidProtocolBufferException(responseProto.getType() + " cannot be decoded!" + e.getMessage());
        }
    }
}

