/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.AbstractOverReplicationHandler;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.RatisContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerUtil;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisOverReplicationHandler
extends AbstractOverReplicationHandler {
    public static final Logger LOG = LoggerFactory.getLogger(RatisOverReplicationHandler.class);
    private final ReplicationManager replicationManager;

    public RatisOverReplicationHandler(PlacementPolicy placementPolicy, ReplicationManager replicationManager) {
        super(placementPolicy);
        this.replicationManager = replicationManager;
    }

    @Override
    public int processAndSendCommands(Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, ContainerHealthResult result, int minHealthyForMaintenance) throws IOException {
        ContainerInfo containerInfo = result.getContainerInfo();
        LOG.debug("Handling container {}.", (Object)containerInfo);
        Set<ContainerReplica> healthyReplicas = replicas.stream().filter(r -> {
            try {
                return this.replicationManager.getNodeStatus(r.getDatanodeDetails()).isHealthy();
            }
            catch (NodeNotFoundException e) {
                return false;
            }
        }).collect(Collectors.toSet());
        RatisContainerReplicaCount replicaCount = new RatisContainerReplicaCount(containerInfo, healthyReplicas, pendingOps, minHealthyForMaintenance, true);
        if (!this.verifyOverReplication(replicaCount)) {
            return 0;
        }
        int pendingDelete = 0;
        for (ContainerReplicaOp op : pendingOps) {
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) continue;
            ++pendingDelete;
        }
        LOG.info("Container {} is over replicated. Actual replica count is {}, with {} pending delete(s). Expected replica count is {}.", new Object[]{containerInfo.containerID(), replicaCount.getReplicas().size(), pendingDelete, replicaCount.getReplicationFactor()});
        List<ContainerReplica> eligibleReplicas = this.getEligibleReplicas(replicaCount, pendingOps);
        if (eligibleReplicas.isEmpty()) {
            LOG.info("Did not find any replicas that are eligible to be deleted for container {}.", (Object)containerInfo);
            return 0;
        }
        int excess = replicaCount.getExcessRedundancy(true);
        return this.createCommands(containerInfo, eligibleReplicas, excess);
    }

    private boolean verifyOverReplication(RatisContainerReplicaCount replicaCount) {
        if (!replicaCount.isOverReplicated()) {
            LOG.info("Container {} is actually not over-replicated any more.", (Object)replicaCount.getContainer().containerID());
            return false;
        }
        return true;
    }

    private List<ContainerReplica> getEligibleReplicas(RatisContainerReplicaCount replicaCount, List<ContainerReplicaOp> pendingOps) {
        List<ContainerReplica> eligibleReplicas = this.sortReplicas(replicaCount.getReplicas(), replicaCount.getHealthyReplicaCount() == 0);
        HashSet<DatanodeDetails> pendingDeletion = new HashSet<DatanodeDetails>();
        for (ContainerReplicaOp op : pendingOps) {
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) continue;
            pendingDeletion.add(op.getTarget());
        }
        eligibleReplicas.removeIf(replica -> replica.getDatanodeDetails().getPersistedOpState() != HddsProtos.NodeOperationalState.IN_SERVICE || pendingDeletion.contains(replica.getDatanodeDetails()));
        if (replicaCount.getContainer().getState() != HddsProtos.LifeCycleState.CLOSED) {
            this.saveReplicasWithUniqueOrigins(replicaCount.getContainer(), eligibleReplicas);
        }
        return eligibleReplicas;
    }

    private void saveReplicasWithUniqueOrigins(ContainerInfo container, List<ContainerReplica> eligibleReplicas) {
        List<ContainerReplica> nonUniqueDeleteCandidates = ReplicationManagerUtil.findNonUniqueDeleteCandidates(new HashSet<ContainerReplica>(eligibleReplicas), eligibleReplicas, dnd -> {
            try {
                return this.replicationManager.getNodeStatus((DatanodeDetails)dnd);
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Exception while finding excess unhealthy replicas to delete for container {} with eligible replicas {}.", new Object[]{container, eligibleReplicas, e});
                return null;
            }
        });
        eligibleReplicas.removeIf(replica -> !nonUniqueDeleteCandidates.contains(replica));
    }

    private List<ContainerReplica> sortReplicas(Collection<ContainerReplica> replicas, boolean allUnhealthy) {
        if (allUnhealthy) {
            return replicas.stream().sorted(Comparator.comparingLong(ContainerReplica::getSequenceId).thenComparing(ContainerReplica::hashCode)).collect(Collectors.toList());
        }
        return replicas.stream().sorted(Comparator.comparingLong(ContainerReplica::hashCode)).collect(Collectors.toList());
    }

    private int createCommands(ContainerInfo containerInfo, List<ContainerReplica> replicas, int excess) throws NotLeaderException, CommandTargetOverloadedException {
        int commandsSent = 0;
        int initialExcess = excess;
        CommandTargetOverloadedException firstOverloadedException = null;
        ArrayList<ContainerReplica> replicasRemoved = new ArrayList<ContainerReplica>();
        for (ContainerReplica replica : replicas) {
            if (excess == 0) break;
            if (ReplicationManager.compareState(containerInfo.getState(), replica.getState())) continue;
            try {
                this.replicationManager.sendThrottledDeleteCommand(containerInfo, replica.getReplicaIndex(), replica.getDatanodeDetails(), true);
                ++commandsSent;
            }
            catch (CommandTargetOverloadedException e) {
                LOG.debug("Unable to send delete command for a mis-matched state container {} to {} as it has too many pending delete commands", (Object)containerInfo.containerID(), (Object)replica.getDatanodeDetails());
                firstOverloadedException = e;
            }
            replicasRemoved.add(replica);
            --excess;
        }
        replicas.removeAll(replicasRemoved);
        HashSet<ContainerReplica> replicaSet = new HashSet<ContainerReplica>(replicas);
        ContainerPlacementStatus originalPlacementStatus = this.getPlacementStatus(replicaSet, containerInfo.getReplicationFactor().getNumber());
        for (ContainerReplica replica : replicas) {
            block7: {
                if (excess == 0) break;
                if (!super.isPlacementStatusActuallyEqualAfterRemove(originalPlacementStatus, replicaSet, replica, containerInfo.getReplicationFactor().getNumber())) continue;
                try {
                    this.replicationManager.sendThrottledDeleteCommand(containerInfo, replica.getReplicaIndex(), replica.getDatanodeDetails(), true);
                    ++commandsSent;
                }
                catch (CommandTargetOverloadedException e) {
                    LOG.debug("Unable to send delete command for container {} to {} as it has too many pending delete commands", (Object)containerInfo.containerID(), (Object)replica.getDatanodeDetails());
                    if (firstOverloadedException != null) break block7;
                    firstOverloadedException = e;
                }
            }
            --excess;
            replicaSet.remove(replica);
        }
        if (firstOverloadedException != null && commandsSent != initialExcess) {
            throw firstOverloadedException;
        }
        return commandsSent;
    }
}

