/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class ContainerHealthResult {
    private final ContainerInfo containerInfo;
    private final HealthState healthState;
    private final List<SCMCommand<?>> commands = new ArrayList();

    public ContainerHealthResult(ContainerInfo containerInfo, HealthState healthState) {
        this.containerInfo = containerInfo;
        this.healthState = healthState;
    }

    public HealthState getHealthState() {
        return this.healthState;
    }

    public void addCommand(SCMCommand<?> command) {
        this.commands.add(command);
    }

    public List<SCMCommand<?>> getCommands() {
        return this.commands;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public static class OverReplicatedHealthResult
    extends ContainerHealthResult {
        private final int excessRedundancy;
        private final boolean sufficientlyReplicatedAfterPending;
        private boolean hasMismatchedReplicas;
        private boolean isSafelyOverReplicated;

        public OverReplicatedHealthResult(ContainerInfo containerInfo, int excessRedundancy, boolean replicatedOkWithPending) {
            super(containerInfo, HealthState.OVER_REPLICATED);
            this.excessRedundancy = excessRedundancy;
            this.sufficientlyReplicatedAfterPending = replicatedOkWithPending;
        }

        public int getExcessRedundancy() {
            return this.excessRedundancy;
        }

        public boolean isReplicatedOkAfterPending() {
            return this.sufficientlyReplicatedAfterPending;
        }

        public boolean hasMismatchedReplicas() {
            return this.hasMismatchedReplicas;
        }

        public void setHasMismatchedReplicas(boolean hasMismatchedReplicas) {
            this.hasMismatchedReplicas = hasMismatchedReplicas;
        }

        public boolean isSafelyOverReplicated() {
            return this.isSafelyOverReplicated;
        }

        public void setIsSafelyOverReplicated(boolean isSafelyOverReplicated) {
            this.isSafelyOverReplicated = isSafelyOverReplicated;
        }
    }

    public static class MisReplicatedHealthResult
    extends UnderReplicatedHealthResult {
        private static final int MIS_REP_REDUNDANCY = 6;
        private final String misReplicatedReason;

        public MisReplicatedHealthResult(ContainerInfo containerInfo, boolean replicatedOkAfterPending, String misReplicatedReason) {
            super(containerInfo, 6, false, replicatedOkAfterPending, false, HealthState.MIS_REPLICATED);
            this.misReplicatedReason = misReplicatedReason;
        }

        public String getMisReplicatedReason() {
            return this.misReplicatedReason;
        }
    }

    public static class UnderReplicatedHealthResult
    extends ContainerHealthResult {
        private static final int OUT_OF_SERVICE_REDUNDANCY = 5;
        private final int remainingRedundancy;
        private final boolean dueToOutOfService;
        private final boolean sufficientlyReplicatedAfterPending;
        private final boolean unrecoverable;
        private boolean isMissing = false;
        private boolean hasHealthyReplicas;
        private boolean hasUnReplicatedOfflineIndexes = false;
        private boolean offlineIndexesOkAfterPending = false;
        private int requeueCount = 0;
        private boolean hasVulnerableUnhealthy = false;

        public UnderReplicatedHealthResult(ContainerInfo containerInfo, int remainingRedundancy, boolean dueToOutOfService, boolean replicatedOkWithPending, boolean unrecoverable) {
            this(containerInfo, remainingRedundancy, dueToOutOfService, replicatedOkWithPending, unrecoverable, HealthState.UNDER_REPLICATED);
        }

        protected UnderReplicatedHealthResult(ContainerInfo containerInfo, int remainingRedundancy, boolean dueToOutOfService, boolean replicatedOkWithPending, boolean unrecoverable, HealthState healthState) {
            super(containerInfo, healthState);
            this.remainingRedundancy = remainingRedundancy;
            this.dueToOutOfService = dueToOutOfService;
            this.sufficientlyReplicatedAfterPending = replicatedOkWithPending;
            this.unrecoverable = unrecoverable;
        }

        public int getRemainingRedundancy() {
            return this.remainingRedundancy;
        }

        public int getWeightedRedundancy() {
            int result = this.requeueCount;
            result = this.dueToOutOfService ? (result += 5) : (result += this.getRemainingRedundancy());
            return result;
        }

        public void incrementRequeueCount() {
            ++this.requeueCount;
        }

        public int getRequeueCount() {
            return this.requeueCount;
        }

        public boolean underReplicatedDueToOutOfService() {
            return this.dueToOutOfService;
        }

        public boolean isReplicatedOkAfterPending() {
            return this.sufficientlyReplicatedAfterPending;
        }

        public boolean isUnrecoverable() {
            return this.unrecoverable;
        }

        public void setHasUnReplicatedOfflineIndexes(boolean val) {
            this.hasUnReplicatedOfflineIndexes = val;
        }

        public boolean hasUnreplicatedOfflineIndexes() {
            return this.hasUnReplicatedOfflineIndexes;
        }

        public void setOfflineIndexesOkAfterPending(boolean val) {
            this.offlineIndexesOkAfterPending = val;
        }

        public boolean offlineIndexesOkAfterPending() {
            return this.offlineIndexesOkAfterPending;
        }

        public boolean hasHealthyReplicas() {
            return this.hasHealthyReplicas;
        }

        public void setHasHealthyReplicas(boolean hasHealthyReplicas) {
            this.hasHealthyReplicas = hasHealthyReplicas;
        }

        public void setIsMissing(boolean isMissing) {
            this.isMissing = isMissing;
        }

        public boolean isMissing() {
            return this.isMissing;
        }

        public void setHasVulnerableUnhealthy(boolean hasVulnerableUnhealthy) {
            this.hasVulnerableUnhealthy = hasVulnerableUnhealthy;
        }

        public boolean hasVulnerableUnhealthy() {
            return this.hasVulnerableUnhealthy;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("UnderReplicatedHealthResult{").append("containerId=").append(this.getContainerInfo().getContainerID()).append(", state=").append((Object)this.getHealthState()).append(", remainingRedundancy=").append(this.remainingRedundancy);
            if (this.dueToOutOfService) {
                sb.append(" +dueToOutOfService");
            }
            if (this.sufficientlyReplicatedAfterPending) {
                sb.append(" +sufficientlyReplicatedAfterPending");
            }
            if (this.unrecoverable) {
                sb.append(" +unrecoverable");
            }
            if (this.isMissing) {
                sb.append(" +missing");
            }
            if (this.hasHealthyReplicas) {
                sb.append(" +hasHealthyReplicas");
            }
            if (this.hasUnReplicatedOfflineIndexes) {
                sb.append(" +hasUnReplicatedOfflineIndexes");
            }
            if (this.requeueCount > 0) {
                sb.append(" requeued:").append(this.requeueCount);
            }
            return sb.append("}").toString();
        }
    }

    public static class UnHealthyResult
    extends ContainerHealthResult {
        public UnHealthyResult(ContainerInfo containerInfo) {
            super(containerInfo, HealthState.UNHEALTHY);
        }
    }

    public static class HealthyResult
    extends ContainerHealthResult {
        public HealthyResult(ContainerInfo containerInfo) {
            super(containerInfo, HealthState.HEALTHY);
        }
    }

    public static enum HealthState {
        HEALTHY,
        UNHEALTHY,
        UNDER_REPLICATED,
        OVER_REPLICATED,
        MIS_REPLICATED;

    }
}

