/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PlacementPolicyValidateProxy;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.balancer.AbstractFindTargetGreedy;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindTargetGreedyByNetworkTopology
extends AbstractFindTargetGreedy {
    public static final Logger LOG = LoggerFactory.getLogger(FindTargetGreedyByNetworkTopology.class);
    private NetworkTopology networkTopology;
    private List potentialTargets;

    public FindTargetGreedyByNetworkTopology(ContainerManager containerManager, PlacementPolicyValidateProxy placementPolicyValidateProxy, NodeManager nodeManager, NetworkTopology networkTopology) {
        super(containerManager, placementPolicyValidateProxy, nodeManager);
        this.setLogger(LOG);
        this.potentialTargets = new LinkedList();
        this.setPotentialTargets(this.potentialTargets);
        this.networkTopology = networkTopology;
    }

    @Override
    @VisibleForTesting
    public void sortTargetForSource(DatanodeDetails source) {
        Collections.sort(this.potentialTargets, (da, db) -> {
            int distanceToB;
            DatanodeDetails a = da.getDatanodeDetails();
            DatanodeDetails b = db.getDatanodeDetails();
            int distanceToA = this.networkTopology.getDistanceCost((Node)source, (Node)a);
            if (distanceToA != (distanceToB = this.networkTopology.getDistanceCost((Node)source, (Node)b))) {
                return distanceToA - distanceToB;
            }
            return this.compareByUsage((DatanodeUsageInfo)da, (DatanodeUsageInfo)db);
        });
    }

    @Override
    public void resetPotentialTargets(@Nonnull Collection<DatanodeDetails> targets) {
        ArrayList<DatanodeUsageInfo> usageInfos = new ArrayList<DatanodeUsageInfo>(targets.size());
        targets.forEach(datanodeDetails -> usageInfos.add(this.getNodeManager().getUsageInfo((DatanodeDetails)datanodeDetails)));
        super.resetTargets(usageInfos);
    }
}

