/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.metadata.Replicate;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;

public interface ContainerStateManager {
    public boolean contains(ContainerID var1);

    public List<ContainerInfo> getContainerInfos(ContainerID var1, int var2);

    public List<ContainerInfo> getContainerInfos(HddsProtos.LifeCycleState var1, ContainerID var2, int var3);

    public List<ContainerInfo> getContainerInfos(HddsProtos.LifeCycleState var1);

    public int getContainerCount(HddsProtos.LifeCycleState var1);

    public List<ContainerInfo> getContainerInfos(HddsProtos.ReplicationType var1);

    public ContainerInfo getContainer(ContainerID var1);

    public Set<ContainerReplica> getContainerReplicas(ContainerID var1);

    public void updateContainerReplica(ContainerReplica var1);

    public void removeContainerReplica(ContainerReplica var1);

    @Replicate
    public void addContainer(HddsProtos.ContainerInfoProto var1) throws IOException;

    @Replicate
    public void updateContainerState(HddsProtos.ContainerID var1, HddsProtos.LifeCycleEvent var2) throws IOException, InvalidStateTransitionException;

    @Replicate
    public void transitionDeletingOrDeletedToClosedState(HddsProtos.ContainerID var1) throws IOException;

    public void updateDeleteTransactionId(Map<ContainerID, Long> var1) throws IOException;

    public ContainerInfo getMatchingContainer(long var1, String var3, PipelineID var4, NavigableSet<ContainerID> var5);

    @Replicate
    public void removeContainer(HddsProtos.ContainerID var1) throws IOException;

    public void reinitialize(Table<ContainerID, ContainerInfo> var1) throws IOException;

    public void close() throws IOException;
}

