/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.snapshot;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"snapshotInfoTable"})
public class OMSnapshotRenameResponse
extends OMClientResponse {
    private String snapshotOldName;
    private String snapshotNewName;
    private SnapshotInfo renamedInfo;

    public OMSnapshotRenameResponse(OzoneManagerProtocolProtos.OMResponse omResponse, String snapshotOldName, String snapshotNewName, @Nonnull SnapshotInfo renamedInfo) {
        super(omResponse);
        this.snapshotOldName = snapshotOldName;
        this.snapshotNewName = snapshotNewName;
        this.renamedInfo = renamedInfo;
    }

    public OMSnapshotRenameResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getSnapshotInfoTable().putWithBatch(batchOperation, (Object)this.snapshotNewName, (Object)this.renamedInfo);
        omMetadataManager.getSnapshotInfoTable().deleteWithBatch(batchOperation, (Object)this.snapshotOldName);
    }
}

