/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeSetQuotaResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetQuotaRequest
extends OMVolumeRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMVolumeSetQuotaRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMVolumeSetQuotaRequest.class);
    }

    public OMVolumeSetQuotaRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder setPropertyRequestBuilde = this.getOmRequest().getSetVolumePropertyRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setSetVolumePropertyRequest(setPropertyRequestBuilde).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientResponse omClientResponse;
        Exception exception;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String volume;
        OzoneManagerProtocolProtos.SetVolumePropertyRequest setVolumePropertyRequest;
        block19: {
            long transactionLogIndex = context.getIndex();
            setVolumePropertyRequest = this.getOmRequest().getSetVolumePropertyRequest();
            Preconditions.checkNotNull((Object)setVolumePropertyRequest);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            if (!setVolumePropertyRequest.hasQuotaInBytes() && !setVolumePropertyRequest.hasQuotaInNamespace()) {
                omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
                return new OMVolumeSetQuotaResponse(omResponse.build());
            }
            volume = setVolumePropertyRequest.getVolumeName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeUpdates();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildVolumeAuditMap(volume);
            auditMap.put("quotaInBytes", String.valueOf(setVolumePropertyRequest.getQuotaInBytes()));
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            exception = null;
            boolean acquireVolumeLock = false;
            omClientResponse = null;
            try {
                try {
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, null, null);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume}));
                    acquireVolumeLock = this.getOmLockDetails().isLockAcquired();
                    OmVolumeArgs omVolumeArgs = this.getVolumeInfo(omMetadataManager, volume);
                    if (this.checkQuotaBytesValid(omMetadataManager, setVolumePropertyRequest.getQuotaInBytes(), volume)) {
                        omVolumeArgs.setQuotaInBytes(setVolumePropertyRequest.getQuotaInBytes());
                    } else {
                        omVolumeArgs.setQuotaInBytes(omVolumeArgs.getQuotaInBytes());
                    }
                    if (this.checkQuotaNamespaceValid(omMetadataManager, setVolumePropertyRequest.getQuotaInNamespace(), volume)) {
                        omVolumeArgs.setQuotaInNamespace(setVolumePropertyRequest.getQuotaInNamespace());
                    } else {
                        omVolumeArgs.setQuotaInNamespace(omVolumeArgs.getQuotaInNamespace());
                    }
                    omVolumeArgs.setUpdateID(transactionLogIndex);
                    omVolumeArgs.setModificationTime(setVolumePropertyRequest.getModificationTime());
                    omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getVolumeKey(volume)), CacheValue.get((long)transactionLogIndex, (Object)omVolumeArgs));
                    omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().build());
                    omClientResponse = new OMVolumeSetQuotaResponse(omResponse.build(), omVolumeArgs);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMVolumeSetQuotaResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquireVolumeLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (acquireVolumeLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquireVolumeLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.SET_QUOTA, auditMap, exception, userInfo));
        if (exception == null) {
            LOG.debug("Changing volume quota is successfully completed for volume: {} quota:{}", (Object)volume, (Object)setVolumePropertyRequest.getQuotaInBytes());
        } else {
            omMetrics.incNumVolumeUpdateFails();
            LOG.error("Changing volume quota failed for volume:{} quota:{}", new Object[]{volume, setVolumePropertyRequest.getQuotaInBytes(), exception});
        }
        return omClientResponse;
    }

    public boolean checkQuotaBytesValid(OMMetadataManager metadataManager, long volumeQuotaInBytes, String volumeName) throws IOException {
        long totalBucketQuota = 0L;
        if (volumeQuotaInBytes < -1L || volumeQuotaInBytes == 0L) {
            return false;
        }
        if (volumeQuotaInBytes == -1L) {
            return true;
        }
        boolean isBucketQuotaSet = true;
        List bucketList = metadataManager.listBuckets(volumeName, null, null, Integer.MAX_VALUE, false);
        for (OmBucketInfo bucketInfo : bucketList) {
            if (bucketInfo.isLink()) continue;
            long nextQuotaInBytes = bucketInfo.getQuotaInBytes();
            if (nextQuotaInBytes > -1L) {
                totalBucketQuota += nextQuotaInBytes;
                continue;
            }
            isBucketQuotaSet = false;
            break;
        }
        if (!isBucketQuotaSet) {
            throw new OMException("Can not set volume space quota on volume as some of buckets in this volume have no quota set.", OMException.ResultCodes.QUOTA_ERROR);
        }
        if (volumeQuotaInBytes < totalBucketQuota && volumeQuotaInBytes != -1L) {
            throw new OMException("Total buckets quota in this volume should not be greater than volume quota : the total space quota is:" + totalBucketQuota + ". But the volume space quota is:" + volumeQuotaInBytes, OMException.ResultCodes.QUOTA_EXCEEDED);
        }
        return true;
    }

    public boolean checkQuotaNamespaceValid(OMMetadataManager metadataManager, long quotaInNamespace, String volumeName) throws IOException {
        if (quotaInNamespace < -1L || quotaInNamespace == 0L) {
            return false;
        }
        if (quotaInNamespace == -1L) {
            return true;
        }
        List bucketList = metadataManager.listBuckets(volumeName, null, null, Integer.MAX_VALUE, false);
        if ((long)bucketList.size() > quotaInNamespace) {
            throw new OMException("Total number of buckets " + bucketList.size() + " in this volume should not be greater than volume namespace quota " + quotaInNamespace, OMException.ResultCodes.QUOTA_EXCEEDED);
        }
        return true;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMVolumeSetQuotaRequest.java", OMVolumeSetQuotaRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.volume.OMVolumeSetQuotaRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 65);
    }
}

