/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotMoveTableKeysResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.server.protocol.TermIndex;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OMSnapshotMoveTableKeysRequest
extends OMClientRequest {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public OMSnapshotMoveTableKeysRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
        OzoneManagerProtocolProtos.SnapshotMoveTableKeysRequest moveTableKeysRequest = this.getOmRequest().getSnapshotMoveTableKeysRequest();
        SnapshotInfo fromSnapshot = SnapshotUtils.getSnapshotInfo(ozoneManager, snapshotChainManager, HddsUtils.fromProtobuf((HddsProtos.UUID)moveTableKeysRequest.getFromSnapshotID()));
        String bucketKeyPrefix = omMetadataManager.getBucketKeyPrefix(fromSnapshot.getVolumeName(), fromSnapshot.getBucketName());
        String bucketKeyPrefixFSO = omMetadataManager.getBucketKeyPrefixFSO(fromSnapshot.getVolumeName(), fromSnapshot.getBucketName());
        HashSet<String> keys = new HashSet<String>();
        ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedKeys = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>(moveTableKeysRequest.getDeletedKeysList().size());
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos deletedKey : moveTableKeysRequest.getDeletedKeysList()) {
            if (deletedKey.getKeyInfosList().isEmpty()) continue;
            deletedKeys.add(deletedKey);
            if (!deletedKey.getKey().startsWith(bucketKeyPrefix)) {
                throw new OMException("Deleted Key: " + deletedKey + " doesn't start with prefix " + bucketKeyPrefix, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            if (keys.contains(deletedKey.getKey())) {
                throw new OMException("Duplicate Deleted Key: " + deletedKey + " in request", OMException.ResultCodes.INVALID_REQUEST);
            }
            keys.add(deletedKey.getKey());
        }
        keys.clear();
        ArrayList<HddsProtos.KeyValue> renamedKeysList = new ArrayList<HddsProtos.KeyValue>(moveTableKeysRequest.getRenamedKeysList().size());
        for (HddsProtos.KeyValue renamedKey : moveTableKeysRequest.getRenamedKeysList()) {
            if (!renamedKey.hasKey() || !renamedKey.hasValue()) continue;
            renamedKeysList.add(renamedKey);
            if (!renamedKey.getKey().startsWith(bucketKeyPrefix)) {
                throw new OMException("Rename Key: " + renamedKey + " doesn't start with prefix " + bucketKeyPrefix, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            if (keys.contains(renamedKey.getKey())) {
                throw new OMException("Duplicate rename Key: " + renamedKey + " in request", OMException.ResultCodes.INVALID_REQUEST);
            }
            keys.add(renamedKey.getKey());
        }
        keys.clear();
        ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedDirs = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>(moveTableKeysRequest.getDeletedDirsList().size());
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos deletedDir : moveTableKeysRequest.getDeletedDirsList()) {
            if (deletedDir.getKeyInfosList().size() != 1) continue;
            deletedDirs.add(deletedDir);
            if (!deletedDir.getKey().startsWith(bucketKeyPrefixFSO)) {
                throw new OMException("Deleted dir: " + deletedDir + " doesn't start with prefix " + bucketKeyPrefixFSO, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            if (keys.contains(deletedDir.getKey())) {
                throw new OMException("Duplicate deleted dir Key: " + deletedDir + " in request", OMException.ResultCodes.INVALID_REQUEST);
            }
            keys.add(deletedDir.getKey());
        }
        return this.getOmRequest().toBuilder().setSnapshotMoveTableKeysRequest(moveTableKeysRequest.toBuilder().clearDeletedDirs().clearDeletedKeys().clearRenamedKeys().addAllDeletedKeys(deletedKeys).addAllDeletedDirs(deletedDirs).addAllRenamedKeys(renamedKeysList).build()).build();
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMSnapshotMoveTableKeysResponse omClientResponse;
        OzoneManager ozoneManager2 = ozoneManager;
        ExecutionContext executionContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)ozoneManager2, (Object)executionContext);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
        OzoneManagerProtocolProtos.SnapshotMoveTableKeysRequest moveTableKeysRequest = this.getOmRequest().getSnapshotMoveTableKeysRequest();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        try {
            SnapshotInfo fromSnapshot = SnapshotUtils.getSnapshotInfo(ozoneManager, snapshotChainManager, HddsUtils.fromProtobuf((HddsProtos.UUID)moveTableKeysRequest.getFromSnapshotID()));
            SnapshotInfo nextSnapshot = SnapshotUtils.getNextSnapshot(ozoneManager, snapshotChainManager, fromSnapshot);
            if (nextSnapshot != null && nextSnapshot.getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE) {
                throw new OMException("Next snapshot : " + nextSnapshot + " in chain is not active.", OMException.ResultCodes.INVALID_SNAPSHOT_ERROR);
            }
            fromSnapshot.setLastTransactionInfo(TransactionInfo.valueOf((TermIndex)context.getTermIndex()).toByteString());
            omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)fromSnapshot.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)fromSnapshot));
            if (nextSnapshot != null) {
                nextSnapshot.setLastTransactionInfo(TransactionInfo.valueOf((TermIndex)context.getTermIndex()).toByteString());
                omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)nextSnapshot.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)nextSnapshot));
            }
            omClientResponse = new OMSnapshotMoveTableKeysResponse(omResponse.build(), fromSnapshot, nextSnapshot, moveTableKeysRequest.getDeletedKeysList(), moveTableKeysRequest.getDeletedDirsList(), moveTableKeysRequest.getRenamedKeysList());
        }
        catch (IOException ex) {
            omClientResponse = new OMSnapshotMoveTableKeysResponse(this.createErrorOMResponse(omResponse, ex));
        }
        return omClientResponse;
    }

    static {
        OMSnapshotMoveTableKeysRequest.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMSnapshotMoveTableKeysRequest.java", OMSnapshotMoveTableKeysRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotMoveTableKeysRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateAndUpdateCache", "org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotMoveTableKeysRequest", "org.apache.hadoop.ozone.om.OzoneManager:org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext", "ozoneManager:context", "", "org.apache.hadoop.ozone.om.response.OMClientResponse"), 139);
    }
}

