/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneConfigUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMFileCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFileCreateRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMFileCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMFileCreateRequest.class);
    }

    public OMFileCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = super.preExecute(ozoneManager).getCreateFileRequest();
        Preconditions.checkNotNull((Object)createFileRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
        OMKeyRequest.ValidateKeyArgs validateArgs = new OMKeyRequest.ValidateKeyArgs.Builder().setSnapshotReservedWord(keyArgs.getKeyName()).setKeyName(StringUtils.removeEnd((String)keyArgs.getKeyName(), (String)"._COPYING_")).build();
        this.validateKey(ozoneManager, validateArgs);
        OzoneManagerProtocolProtos.UserInfo userInfo = this.getUserInfo();
        if (keyArgs.getKeyName().isEmpty()) {
            return this.getOmRequest().toBuilder().setUserInfo(userInfo).build();
        }
        long scmBlockSize = ozoneManager.getScmBlockSize();
        long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
        HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
        HddsProtos.ReplicationType type = keyArgs.getType();
        OmBucketInfo bucketInfo = ozoneManager.getBucketInfo(keyArgs.getVolumeName(), keyArgs.getBucketName());
        ReplicationConfig repConfig = OzoneConfigUtil.resolveReplicationConfigPreference(type, factor, keyArgs.getEcReplicationConfig(), bucketInfo.getDefaultReplicationConfig(), ozoneManager);
        List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), repConfig, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMServiceId(), ozoneManager.getMetrics(), keyArgs.getSortDatanodes(), userInfo);
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
        newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(info -> info.getProtobuf(this.getOmRequest().getVersion())).collect(Collectors.toList()));
        this.generateRequiredEncryptionInfo(keyArgs, newKeyArgs, ozoneManager);
        OzoneManagerProtocolProtos.KeyArgs resolvedArgs = this.resolveBucketAndCheckKeyAcls(newKeyArgs.build(), ozoneManager, IAccessAuthorizer.ACLType.CREATE);
        OzoneManagerProtocolProtos.CreateFileRequest.Builder newCreateFileRequest = createFileRequest.toBuilder().setKeyArgs(resolvedArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateFileRequest(newCreateFileRequest).setUserInfo(userInfo).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        Exception exception;
        OMClientResponse omClientResponse;
        OMMetrics omMetrics;
        int numMissingParents;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest;
        block18: {
            long trxnLogIndex = context.getIndex();
            createFileRequest = this.getOmRequest().getCreateFileRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            numMissingParents = 0;
            boolean isRecursive = createFileRequest.getIsRecursive();
            if (LOG.isDebugEnabled()) {
                LOG.debug("File create for : " + volumeName + "/" + bucketName + "/" + keyName + ":" + isRecursive);
            }
            boolean isOverWrite = createFileRequest.getIsOverwrite();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateFile();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            OmKeyInfo omKeyInfo = null;
            OmBucketInfo omBucketInfo = null;
            ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            result = null;
            try {
                try {
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    if (keyName.isEmpty()) {
                        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                    }
                    String ozoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    OmKeyInfo dbKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).getIfExist((Object)ozoneKey);
                    OMFileRequest.OMPathInfo pathInfo = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                    OMFileRequest.OMDirectoryResult omDirectoryResult = pathInfo.getDirectoryResult();
                    this.checkDirectoryResult(keyName, isOverWrite, omDirectoryResult);
                    if (!isRecursive) {
                        this.checkAllParentsExist(keyArgs, pathInfo);
                    }
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    ReplicationConfig repConfig = OzoneConfigUtil.resolveReplicationConfigPreference(keyArgs.getType(), keyArgs.getFactor(), keyArgs.getEcReplicationConfig(), omBucketInfo.getDefaultReplicationConfig(), ozoneManager);
                    omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, dbKeyInfo, keyArgs.getDataSize(), locations, this.getFileEncryptionInfo(keyArgs), ozoneManager.getPrefixManager(), omBucketInfo, pathInfo, trxnLogIndex, ozoneManager.getObjectIdFromTxId(trxnLogIndex), repConfig, ozoneManager.getConfiguration());
                    this.validateEncryptionKeyInfo(omBucketInfo, keyArgs);
                    long openVersion = omKeyInfo.getLatestVersionLocations().getVersion();
                    long clientID = createFileRequest.getClientID();
                    String dbOpenKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                    List<OmKeyInfo> missingParentInfos = this.getAllParentInfo(ozoneManager, keyArgs, pathInfo.getMissingParents(), omBucketInfo, pathInfo, trxnLogIndex);
                    List newLocationList = keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList());
                    omKeyInfo.appendNewBlocks(newLocationList, false);
                    long preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)omKeyInfo.getReplicationConfig().getRequiredNodes();
                    this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, preAllocatedSpace);
                    numMissingParents = missingParentInfos.size();
                    this.checkBucketQuotaInNamespace(omBucketInfo, (long)numMissingParents + 1L);
                    omBucketInfo.incrUsedNamespace((long)numMissingParents);
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry((Object)dbOpenKeyName, (Object)omKeyInfo, trxnLogIndex);
                    OMFileRequest.addKeyTableCacheEntries(omMetadataManager, volumeName, bucketName, omBucketInfo.getBucketLayout(), null, missingParentInfos, trxnLogIndex);
                    omResponse.setCreateFileResponse(OzoneManagerProtocolProtos.CreateFileResponse.newBuilder().setKeyInfo(omKeyInfo.getNetworkProtobuf(this.getOmRequest().getVersion(), keyArgs.getLatestVersionLocation())).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponse(omResponse.build(), omKeyInfo, missingParentInfos, clientID, omBucketInfo.copyObject());
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumCreateFileFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.CREATE_FILE, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numMissingParents);
                LOG.debug("File created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                LOG.error("File create failed. Volume:{}, Bucket:{}, Key{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMFileCreateRequest: {}", (Object)createFileRequest);
            }
        }
        return omClientResponse;
    }

    protected void checkDirectoryResult(String keyName, boolean isOverWrite, OMFileRequest.OMDirectoryResult omDirectoryResult) throws OMException {
        if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS) {
            if (!isOverWrite) {
                throw new OMException("File " + keyName + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
            }
        } else {
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
                throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
            }
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                throw new OMException("Can not create file: " + keyName + " as there " + "is already file in the given path", OMException.ResultCodes.NOT_A_FILE);
            }
        }
    }

    protected void checkAllParentsExist(OzoneManagerProtocolProtos.KeyArgs keyArgs, OMFileRequest.OMPathInfo pathInfo) throws IOException {
        String keyName = keyArgs.getKeyName();
        if (!pathInfo.directParentExists()) {
            throw new OMException("Cannot create file : " + keyName + " as one of parent directory is not created", OMException.ResultCodes.DIRECTORY_NOT_FOUND);
        }
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateFile)
    public static OzoneManagerProtocolProtos.OMRequest disallowCreateFileWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getCreateFileRequest().getKeyArgs().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateFile)
    public static OzoneManagerProtocolProtos.OMRequest blockCreateFileWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getCreateFileRequest().hasKeyArgs() && (keyArgs = req.getCreateFileRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMFileCreateRequest.java", OMFileCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.file.OMFileCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 85);
    }
}

