/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket.acl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAclRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.acl.OMBucketAclResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketAddAclRequest
extends OMBucketAclRequest {
    private static final Logger LOG;
    private final String path;
    private final List<OzoneAcl> ozoneAcls;
    private final OzoneObj obj;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMBucketAddAclRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMBucketAddAclRequest.class);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        long modificationTime = Time.now();
        OzoneManagerProtocolProtos.AddAclRequest.Builder addAclRequestBuilder = this.getOmRequest().getAddAclRequest().toBuilder().setModificationTime(modificationTime);
        return this.getOmRequest().toBuilder().setAddAclRequest(addAclRequestBuilder).setUserInfo(this.getUserInfo()).build();
    }

    public OMBucketAddAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, (acls, omBucketInfo) -> omBucketInfo.addAcl((OzoneAcl)acls.get(0)));
        OzoneManagerProtocolProtos.AddAclRequest addAclRequest = this.getOmRequest().getAddAclRequest();
        this.obj = OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)addAclRequest.getObj());
        this.path = this.obj.getPath();
        this.ozoneAcls = Lists.newArrayList((Object[])new OzoneAcl[]{OzoneAcl.fromProtobuf((OzoneManagerProtocolProtos.OzoneAclInfo)addAclRequest.getAcl())});
    }

    @Override
    List<OzoneAcl> getAcls() {
        return this.ozoneAcls;
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    OzoneObj getObject() {
        return this.obj;
    }

    @Override
    OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    @Override
    OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmBucketInfo omBucketInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setAddAclResponse(OzoneManagerProtocolProtos.AddAclResponse.newBuilder().setResponse(operationResult));
        return new OMBucketAclResponse(omResponse.build(), omBucketInfo);
    }

    @Override
    void onComplete(boolean operationResult, Exception exception, OMMetrics omMetrics, AuditLogger auditLogger, Map<String, String> auditMap) {
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.ADD_ACL, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (operationResult) {
            LOG.debug("Add acl: {} to path: {} success!", this.getAcls(), (Object)this.getPath());
        } else {
            omMetrics.incNumBucketUpdateFails();
            if (exception == null) {
                LOG.error("Add acl {} to path {} failed, because acl already exist", this.getAcls(), (Object)this.getPath());
            } else {
                LOG.error("Add acl {} to path {} failed!", new Object[]{this.getAcls(), this.getPath(), exception});
            }
        }
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        ozoneManager.getMetrics().incNumAddAcl();
        return super.validateAndUpdateCache(ozoneManager, context);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMBucketAddAclRequest.java", OMBucketAddAclRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAddAclRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 57);
    }
}

