/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.RatisConfUtils;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RpcConstants;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerStateMachine;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RetryCache;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerRatisServer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerRatisServer.class);
    private final int port;
    private final RaftServer server;
    private final Supplier<RaftServer.Division> serverDivision;
    private final RaftGroupId raftGroupId;
    private final RaftGroup raftGroup;
    private final RaftPeerId raftPeerId;
    private final Map<String, RaftPeer> raftPeerMap;
    private final OzoneManager ozoneManager;
    private final OzoneManagerStateMachine omStateMachine;
    private final String ratisStorageDir;
    private final OMPerformanceMetrics perfMetrics;
    private final ClientId clientId = ClientId.randomId();
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();

    private static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    private OzoneManagerRatisServer(ConfigurationSource conf, OzoneManager om, String raftGroupIdStr, RaftPeerId localRaftPeerId, InetSocketAddress addr, List<RaftPeer> peers, boolean isBootstrapping, SecurityConfig secConfig, CertificateClient certClient) throws IOException {
        this.ozoneManager = om;
        this.port = addr.getPort();
        this.ratisStorageDir = OzoneManagerRatisUtils.getOMRatisDirectory(conf);
        RaftProperties serverProperties = OzoneManagerRatisServer.newRaftProperties(conf, this.port, this.ratisStorageDir);
        this.raftPeerId = localRaftPeerId;
        this.raftGroupId = RaftGroupId.valueOf((UUID)OzoneManagerRatisServer.getRaftGroupIdFromOmServiceId(raftGroupIdStr));
        this.raftPeerMap = Maps.newHashMap();
        peers.forEach(e -> {
            RaftPeer raftPeer = this.raftPeerMap.put(e.getId().toString(), (RaftPeer)e);
        });
        this.raftGroup = RaftGroup.valueOf((RaftGroupId)this.raftGroupId, peers);
        if (isBootstrapping) {
            LOG.info("OM started in Bootstrap mode. Instantiating OM Ratis server with groupID: {}", (Object)raftGroupIdStr);
        } else {
            StringBuilder raftPeersStr = new StringBuilder();
            for (RaftPeer peer : peers) {
                raftPeersStr.append(", ").append(peer.getAddress());
            }
            LOG.info("Instantiating OM Ratis server with groupID: {} and peers: {}", (Object)raftGroupIdStr, (Object)raftPeersStr.substring(2));
        }
        this.omStateMachine = this.getStateMachine(conf);
        Parameters parameters = OzoneManagerRatisServer.createServerTlsParameters(secConfig, certClient);
        this.server = RaftServer.newBuilder().setServerId(this.raftPeerId).setGroup(this.raftGroup).setProperties(serverProperties).setParameters(parameters).setStateMachine((StateMachine)this.omStateMachine).setOption(RaftStorage.StartupOption.RECOVER).build();
        this.serverDivision = MemoizedSupplier.valueOf(() -> {
            try {
                return this.server.getDivision(this.raftGroupId);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to getDivision for " + this.raftGroupId, e);
            }
        });
        this.perfMetrics = om.getPerfMetrics();
    }

    public static OzoneManagerRatisServer newOMRatisServer(ConfigurationSource ozoneConf, OzoneManager omProtocol, OMNodeDetails omNodeDetails, Map<String, OMNodeDetails> peerNodes, SecurityConfig secConfig, CertificateClient certClient, boolean isBootstrapping) throws IOException {
        String omServiceId = omNodeDetails.getServiceId();
        String omNodeId = omNodeDetails.getNodeId();
        RaftPeerId localRaftPeerId = RaftPeerId.getRaftPeerId((String)omNodeId);
        InetSocketAddress ratisAddr = new InetSocketAddress(omNodeDetails.getInetAddress(), omNodeDetails.getRatisPort());
        RaftPeer localRaftPeer = RaftPeer.newBuilder().setId(localRaftPeerId).setAddress(ratisAddr).build();
        ArrayList<RaftPeer> raftPeers = new ArrayList<RaftPeer>();
        if (!isBootstrapping) {
            raftPeers.add(localRaftPeer);
            for (Map.Entry<String, OMNodeDetails> peerInfo : peerNodes.entrySet()) {
                RaftPeer raftPeer;
                String peerNodeId = peerInfo.getKey();
                OMNodeDetails peerNode = peerInfo.getValue();
                RaftPeerId raftPeerId = RaftPeerId.valueOf((String)peerNodeId);
                if (peerNode.isHostUnresolved()) {
                    raftPeer = RaftPeer.newBuilder().setId(raftPeerId).setAddress(peerNode.getRatisHostPortStr()).build();
                } else {
                    InetSocketAddress peerRatisAddr = new InetSocketAddress(peerNode.getInetAddress(), peerNode.getRatisPort());
                    raftPeer = RaftPeer.newBuilder().setId(raftPeerId).setAddress(peerRatisAddr).build();
                }
                raftPeers.add(raftPeer);
            }
        }
        return new OzoneManagerRatisServer(ozoneConf, omProtocol, omServiceId, localRaftPeerId, ratisAddr, raftPeers, isBootstrapping, secConfig, certClient);
    }

    public OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws ServiceException {
        if (this.ozoneManager.getPrepareState().requestAllowed(omRequest.getCmdType())) {
            RaftClientRequest raftClientRequest = this.createRaftRequest(omRequest);
            RaftClientReply raftClientReply = this.submitRequestToRatis(raftClientRequest);
            return this.createOmResponse(omRequest, raftClientReply);
        }
        LOG.info("Rejecting write request on OM {} because it is in prepare mode: {}", (Object)this.ozoneManager.getOMNodeId(), (Object)omRequest.getCmdType().name());
        String message = "Cannot apply write request " + omRequest.getCmdType().name() + " when OM is in prepare mode.";
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setMessage(message).setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION_WHEN_PREPARED).setCmdType(omRequest.getCmdType()).setTraceID(omRequest.getTraceID()).setSuccess(false);
        return omResponse.build();
    }

    private OzoneManagerProtocolProtos.OMResponse createOmResponse(OzoneManagerProtocolProtos.OMRequest omRequest, RaftClientReply raftClientReply) throws ServiceException {
        return (OzoneManagerProtocolProtos.OMResponse)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getCreateOmResponseLatencyNs(), () -> this.createOmResponseImpl(omRequest, raftClientReply));
    }

    private RaftClientReply submitRequestToRatis(RaftClientRequest raftClientRequest) throws ServiceException {
        return (RaftClientReply)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getSubmitToRatisLatencyNs(), () -> this.submitRequestToRatisImpl(raftClientRequest));
    }

    private RaftClientRequest createRaftRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        return (RaftClientRequest)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getCreateRatisRequestLatencyNs(), () -> this.createRaftRequestImpl(omRequest));
    }

    public OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest, ClientId cliId, long callId) throws ServiceException {
        RaftClientRequest raftClientRequest = RaftClientRequest.newBuilder().setClientId(cliId).setServerId(this.getRaftPeerId()).setGroupId(this.getRaftGroupId()).setCallId(callId).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
        RaftClientReply raftClientReply = this.submitRequestToRatis(raftClientRequest);
        return this.createOmResponse(omRequest, raftClientReply);
    }

    private RaftClientReply submitRequestToRatisImpl(RaftClientRequest raftClientRequest) throws ServiceException {
        try {
            return (RaftClientReply)this.server.submitClientRequestAsync(raftClientRequest).get();
        }
        catch (IOException | ExecutionException ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void addOMToRatisRing(OMNodeDetails newOMNode) throws IOException {
        Preconditions.checkNotNull((Object)newOMNode);
        String newOMNodeId = newOMNode.getNodeId();
        RaftPeerId newOMRaftPeerId = RaftPeerId.valueOf((String)newOMNodeId);
        InetSocketAddress newOMRatisAddr = new InetSocketAddress(newOMNode.getHostAddress(), newOMNode.getRatisPort());
        RaftPeer newRaftPeer = RaftPeer.newBuilder().setId(newOMRaftPeerId).setAddress(newOMRatisAddr).build();
        LOG.info("{}: Submitting SetConfiguration request to Ratis server to add new OM peer {} to the Ratis group {}", new Object[]{this.ozoneManager.getOMNodeId(), newRaftPeer, this.raftGroup});
        ArrayList<RaftPeer> newPeersList = new ArrayList<RaftPeer>(this.raftPeerMap.values());
        newPeersList.add(newRaftPeer);
        this.checkLeaderStatus();
        SetConfigurationRequest request = new SetConfigurationRequest(this.clientId, this.server.getId(), this.raftGroupId, OzoneManagerRatisServer.nextCallId(), newPeersList);
        RaftClientReply raftClientReply = this.server.setConfiguration(request);
        if (!raftClientReply.isSuccess()) {
            LOG.error("Failed to add OM {} to Ratis group {}. Ratis SetConfiguration reply: {}", new Object[]{newOMNodeId, this.raftGroupId, raftClientReply});
            throw new IOException("Failed to add OM " + newOMNodeId + " to Ratis " + "ring.");
        }
        LOG.info("Added OM {} to Ratis group {}.", (Object)newOMNodeId, (Object)this.raftGroupId);
    }

    public void removeOMFromRatisRing(OMNodeDetails removeOMNode) throws IOException {
        Preconditions.checkNotNull((Object)removeOMNode);
        String removeNodeId = removeOMNode.getNodeId();
        LOG.info("{}: Submitting SetConfiguration request to Ratis server to remove OM peer {} from Ratis group {}", new Object[]{this.ozoneManager.getOMNodeId(), removeNodeId, this.raftGroup});
        List newPeersList = this.raftPeerMap.entrySet().stream().filter(e -> !((String)e.getKey()).equals(removeNodeId)).map(Map.Entry::getValue).collect(Collectors.toList());
        this.checkLeaderStatus();
        SetConfigurationRequest request = new SetConfigurationRequest(this.clientId, this.server.getId(), this.raftGroupId, OzoneManagerRatisServer.nextCallId(), newPeersList);
        RaftClientReply raftClientReply = this.server.setConfiguration(request);
        if (!raftClientReply.isSuccess()) {
            LOG.error("Failed to remove OM {} from Ratis group {}. Ratis SetConfiguration reply: {}", new Object[]{removeNodeId, this.raftGroupId, raftClientReply});
            throw new IOException("Failed to remove OM " + removeNodeId + " from " + "Ratis ring.");
        }
        LOG.info("Removed OM {} from Ratis group {}.", (Object)removeNodeId, (Object)this.raftGroupId);
    }

    public Set<String> getPeerIds() {
        return Collections.unmodifiableSet(this.raftPeerMap.keySet());
    }

    @VisibleForTesting
    public boolean doesPeerExist(String peerId) {
        return this.raftPeerMap.containsKey(peerId);
    }

    public void addRaftPeer(OMNodeDetails omNodeDetails) {
        InetSocketAddress newOMRatisAddr = new InetSocketAddress(omNodeDetails.getHostAddress(), omNodeDetails.getRatisPort());
        String newNodeId = omNodeDetails.getNodeId();
        RaftPeerId newPeerId = RaftPeerId.valueOf((String)newNodeId);
        RaftPeer raftPeer = RaftPeer.newBuilder().setId(newPeerId).setAddress(newOMRatisAddr).build();
        this.raftPeerMap.put(newNodeId, raftPeer);
        LOG.info("Added OM {} to Ratis Peers list.", (Object)newNodeId);
    }

    public void removeRaftPeer(OMNodeDetails omNodeDetails) {
        String removeNodeID = omNodeDetails.getNodeId();
        this.raftPeerMap.remove(removeNodeID);
        LOG.info("{}: Removed OM {} from Ratis Peers list.", (Object)this, (Object)removeNodeID);
    }

    private RaftClientRequest createRaftRequestImpl(OzoneManagerProtocolProtos.OMRequest omRequest) {
        return RaftClientRequest.newBuilder().setClientId(this.getClientId()).setServerId(this.server.getId()).setGroupId(this.raftGroupId).setCallId(this.getCallId()).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
    }

    private ClientId getClientId() {
        byte[] clientIdBytes = ProtobufRpcEngine.Server.getClientId();
        if (!this.ozoneManager.isTestSecureOmFlag()) {
            Preconditions.checkArgument((clientIdBytes != RpcConstants.DUMMY_CLIENT_ID ? 1 : 0) != 0);
        }
        return ClientId.valueOf((UUID)UUID.nameUUIDFromBytes(clientIdBytes));
    }

    private long getCallId() {
        long callId = ProtobufRpcEngine.Server.getCallId();
        if (!this.ozoneManager.isTestSecureOmFlag()) {
            Preconditions.checkArgument((callId != -2L ? 1 : 0) != 0);
        }
        return callId;
    }

    public OzoneManagerProtocolProtos.OMResponse checkRetryCache() throws ServiceException {
        ClientInvocationId invocationId = ClientInvocationId.valueOf((ClientId)this.getClientId(), (long)this.getCallId());
        RetryCache.Entry cacheEntry = this.getServerDivision().getRetryCache().getIfPresent(invocationId);
        if (cacheEntry == null) {
            return null;
        }
        try {
            return this.getOMResponse((RaftClientReply)cacheEntry.getReplyFuture().get());
        }
        catch (ExecutionException ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private OzoneManagerProtocolProtos.OMResponse createOmResponseImpl(OzoneManagerProtocolProtos.OMRequest omRequest, RaftClientReply reply) throws ServiceException {
        if (!reply.isSuccess()) {
            NotLeaderException notLeaderException = reply.getNotLeaderException();
            if (notLeaderException != null) {
                throw new ServiceException((Throwable)OMNotLeaderException.convertToOMNotLeaderException((NotLeaderException)notLeaderException, (RaftPeerId)this.getRaftPeerId()));
            }
            LeaderNotReadyException leaderNotReadyException = reply.getLeaderNotReadyException();
            if (leaderNotReadyException != null) {
                throw new ServiceException((Throwable)new OMLeaderNotReadyException(leaderNotReadyException.getMessage()));
            }
            LeaderSteppingDownException leaderSteppingDownException = reply.getLeaderSteppingDownException();
            if (leaderSteppingDownException != null) {
                throw new ServiceException((Throwable)new OMNotLeaderException(leaderSteppingDownException.getMessage()));
            }
            StateMachineException stateMachineException = reply.getStateMachineException();
            if (stateMachineException != null) {
                OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(omRequest.getCmdType()).setSuccess(false).setTraceID(omRequest.getTraceID());
                if (stateMachineException.getCause() != null) {
                    omResponse.setMessage(stateMachineException.getCause().getMessage());
                    omResponse.setStatus(this.exceptionToResponseStatus(stateMachineException.getCause()));
                } else {
                    LOG.error("StateMachine exception cause is not set");
                    omResponse.setStatus(OzoneManagerProtocolProtos.Status.INTERNAL_ERROR);
                    omResponse.setMessage(StringUtils.stringifyException((Throwable)stateMachineException));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error while executing ratis request. stateMachineException: ", (Throwable)stateMachineException);
                }
                return omResponse.build();
            }
        }
        return this.getOMResponse(reply);
    }

    private OzoneManagerProtocolProtos.OMResponse getOMResponse(RaftClientReply reply) throws ServiceException {
        try {
            return OMRatisHelper.getOMResponseFromRaftClientReply((RaftClientReply)reply);
        }
        catch (IOException ex) {
            if (ex.getMessage() != null) {
                throw new ServiceException(ex.getMessage(), (Throwable)ex);
            }
            throw new ServiceException((Throwable)ex);
        }
    }

    private OzoneManagerProtocolProtos.Status exceptionToResponseStatus(Throwable cause) {
        if (cause instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)cause).getResult().ordinal()];
        }
        LOG.error("Unknown error occurs", cause);
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    public RaftGroup getRaftGroup() {
        return this.raftGroup;
    }

    @VisibleForTesting
    public RaftServer.Division getServerDivision() {
        return this.serverDivision.get();
    }

    private OzoneManagerStateMachine getStateMachine(ConfigurationSource conf) throws IOException {
        return new OzoneManagerStateMachine(this, TracingUtil.isTracingEnabled((ConfigurationSource)conf));
    }

    @VisibleForTesting
    public OzoneManagerStateMachine getOmStateMachine() {
        return this.omStateMachine;
    }

    public OzoneManager getOzoneManager() {
        return this.ozoneManager;
    }

    public void start() throws IOException {
        LOG.info("Starting {} {} at port {}", new Object[]{this.getClass().getSimpleName(), this.server.getId(), this.port});
        this.server.start();
    }

    public void stop() {
        LOG.info("Stopping {} at port {}", (Object)this, (Object)this.port);
        try {
            this.server.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RaftProperties newRaftProperties(ConfigurationSource conf, int port, String ratisStorageDir) {
        SupportedRpcType rpc = SupportedRpcType.valueOfIgnoreCase((String)conf.get("ozone.om.ratis.rpc.type", "GRPC"));
        RaftProperties properties = RatisHelper.newRaftProperties((RpcType)rpc);
        if (rpc == SupportedRpcType.GRPC) {
            GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)port);
        } else if (rpc == SupportedRpcType.NETTY) {
            NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)port);
        }
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, Collections.singletonList(new File(ratisStorageDir)));
        int logAppenderBufferByteLimit = (int)conf.getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        OzoneManagerRatisServer.setRaftLogProperties(properties, logAppenderBufferByteLimit, conf);
        RatisConfUtils.Grpc.setMessageSizeMax((RaftProperties)properties, (int)logAppenderBufferByteLimit);
        OzoneManagerRatisServer.setRaftLeaderElectionProperties(properties, conf);
        OzoneManagerRatisServer.setRaftRpcProperties(properties, conf);
        OzoneManagerRatisServer.setRaftRetryCacheProperties(properties, conf);
        OzoneManagerRatisServer.setRaftSnapshotProperties(properties, conf);
        OzoneManagerRatisServer.setRaftCloseThreshold(properties, conf);
        OzoneManagerRatisServer.getOMHAConfigs(conf).forEach((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1));
        return properties;
    }

    private static void setRaftLeaderElectionProperties(RaftProperties properties, ConfigurationSource conf) {
        RaftServerConfigKeys.LeaderElection.setPreVote((RaftProperties)properties, (boolean)conf.getBoolean("ozone.om.ratis.server.leaderelection.pre-vote", true));
    }

    private static void setRaftLogProperties(RaftProperties properties, int logAppenderQueueByteLimit, ConfigurationSource conf) {
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)((long)conf.getStorageSize("ozone.om.ratis.segment.size", "4MB", StorageUnit.BYTES))));
        RaftServerConfigKeys.Log.setPurgeUptoSnapshotIndex((RaftProperties)properties, (boolean)conf.getBoolean("ozone.om.ratis.log.purge.upto.snapshot.index", true));
        RaftServerConfigKeys.Log.setPurgePreservationLogNum((RaftProperties)properties, (long)conf.getLong("ozone.om.ratis.log.purge.preservation.log.num", 0L));
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)((long)conf.getStorageSize("ozone.om.ratis.segment.preallocated.size", "4MB", StorageUnit.BYTES))));
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)properties, (int)conf.getInt("ozone.om.ratis.log.appender.queue.num-elements", 1024));
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        RaftServerConfigKeys.Log.setWriteBufferSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)(logAppenderQueueByteLimit + 8)));
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)properties, (boolean)false);
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)properties, (int)conf.getInt("ozone.om.ratis.log.purge.gap", 1000000));
        RaftServerConfigKeys.Log.setSegmentCacheNumMax((RaftProperties)properties, (int)2);
    }

    private static void setRaftRpcProperties(RaftProperties properties, ConfigurationSource conf) {
        TimeUnit serverRequestTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_REQUEST_TIMEOUT_DEFAULT.getUnit();
        TimeDuration serverRequestTimeout = TimeDuration.valueOf((long)conf.getTimeDuration("ozone.om.ratis.server.request.timeout", OMConfigKeys.OZONE_OM_RATIS_SERVER_REQUEST_TIMEOUT_DEFAULT.getDuration(), serverRequestTimeoutUnit), (TimeUnit)serverRequestTimeoutUnit);
        RaftServerConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)serverRequestTimeout);
        TimeUnit serverMinTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_MINIMUM_TIMEOUT_DEFAULT.getUnit();
        TimeDuration serverMinTimeout = TimeDuration.valueOf((long)conf.getTimeDuration("ozone.om.ratis.minimum.timeout", OMConfigKeys.OZONE_OM_RATIS_MINIMUM_TIMEOUT_DEFAULT.getDuration(), serverMinTimeoutUnit), (TimeUnit)serverMinTimeoutUnit);
        TimeDuration serverMaxTimeout = serverMinTimeout.add(200L, TimeUnit.MILLISECONDS);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)serverMinTimeout);
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)serverMaxTimeout);
        TimeUnit nodeFailureTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_FAILURE_TIMEOUT_DURATION_DEFAULT.getUnit();
        TimeDuration nodeFailureTimeout = TimeDuration.valueOf((long)conf.getTimeDuration("ozone.om.ratis.server.failure.timeout.duration", OMConfigKeys.OZONE_OM_RATIS_SERVER_FAILURE_TIMEOUT_DURATION_DEFAULT.getDuration(), nodeFailureTimeoutUnit), (TimeUnit)nodeFailureTimeoutUnit);
        RaftServerConfigKeys.Notification.setNoLeaderTimeout((RaftProperties)properties, (TimeDuration)nodeFailureTimeout);
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)properties, (TimeDuration)nodeFailureTimeout);
    }

    private static void setRaftRetryCacheProperties(RaftProperties properties, ConfigurationSource conf) {
        TimeUnit retryCacheTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DEFAULT.getUnit();
        TimeDuration retryCacheTimeout = TimeDuration.valueOf((long)conf.getTimeDuration("ozone.om.ratis.server.retry.cache.timeout", OMConfigKeys.OZONE_OM_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DEFAULT.getDuration(), retryCacheTimeoutUnit), (TimeUnit)retryCacheTimeoutUnit);
        RaftServerConfigKeys.RetryCache.setExpiryTime((RaftProperties)properties, (TimeDuration)retryCacheTimeout);
    }

    private static void setRaftSnapshotProperties(RaftProperties properties, ConfigurationSource conf) {
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)properties, (boolean)true);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)properties, (long)conf.getLong("ozone.om.ratis.snapshot.auto.trigger.threshold", 400000L));
    }

    private static void setRaftCloseThreshold(RaftProperties properties, ConfigurationSource conf) {
        TimeUnit closeThresholdUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_CLOSE_THRESHOLD_DEFAULT.getUnit();
        int closeThreshold = (int)TimeDuration.valueOf((long)conf.getTimeDuration("ozone.om.ratis.server.close.threshold", OMConfigKeys.OZONE_OM_RATIS_SERVER_CLOSE_THRESHOLD_DEFAULT.getDuration(), closeThresholdUnit), (TimeUnit)closeThresholdUnit).toLong(TimeUnit.SECONDS);
        RaftServerConfigKeys.setCloseThreshold((RaftProperties)properties, (int)closeThreshold);
    }

    private static Map<String, String> getOMHAConfigs(ConfigurationSource configuration) {
        return configuration.getPropsMatchPrefixAndTrimPrefix("ozone.om.ha.");
    }

    public RaftPeerId getLeaderId() {
        return this.getServerDivision().getInfo().getLeaderId();
    }

    public OMNotLeaderException newOMNotLeaderException() {
        RaftPeer leader;
        RaftPeerId leaderId = this.getLeaderId();
        RaftPeer raftPeer = leader = leaderId == null ? null : this.getServerDivision().getRaftConf().getPeer(leaderId, new RaftProtos.RaftPeerRole[0]);
        if (leader == null) {
            return new OMNotLeaderException(this.raftPeerId);
        }
        String leaderAddress = this.getRaftLeaderAddress(leader);
        return new OMNotLeaderException(this.raftPeerId, leader.getId(), leaderAddress);
    }

    public RaftServerStatus checkLeaderStatus() {
        RaftServer.Division division = this.getServerDivision();
        if (division == null) {
            return RaftServerStatus.NOT_LEADER;
        }
        if (!division.getInfo().isLeader()) {
            return RaftServerStatus.NOT_LEADER;
        }
        if (division.getInfo().isLeaderReady()) {
            return RaftServerStatus.LEADER_AND_READY;
        }
        return RaftServerStatus.LEADER_AND_NOT_READY;
    }

    public int getServerPort() {
        return this.port;
    }

    @VisibleForTesting
    public LifeCycle.State getServerState() {
        return this.server.getLifeCycleState();
    }

    @VisibleForTesting
    public RaftPeerId getRaftPeerId() {
        return this.raftPeerId;
    }

    @VisibleForTesting
    public String getRaftLeaderAddress(RaftPeer leaderPeer) {
        InetAddress leaderInetAddress = null;
        try {
            Optional hostname = HddsUtils.getHostName((String)leaderPeer.getAddress());
            if (hostname.isPresent()) {
                leaderInetAddress = InetAddress.getByName((String)hostname.get());
            }
        }
        catch (UnknownHostException e) {
            LOG.error("OM Ratis LeaderInetAddress {} is unresolvable", (Object)leaderPeer.getAddress(), (Object)e);
        }
        return leaderInetAddress == null ? null : leaderInetAddress.toString();
    }

    public static UUID getRaftGroupIdFromOmServiceId(String omServiceId) {
        return UUID.nameUUIDFromBytes(omServiceId.getBytes(StandardCharsets.UTF_8));
    }

    public String getRatisStorageDir() {
        return this.ratisStorageDir;
    }

    public TermIndex getLastAppliedTermIndex() {
        return this.omStateMachine.getLastAppliedTermIndex();
    }

    public RaftGroupId getRaftGroupId() {
        return this.raftGroupId;
    }

    private static Parameters createServerTlsParameters(SecurityConfig conf, CertificateClient caClient) throws IOException {
        GrpcTlsConfig config = OzoneManagerRatisUtils.createServerTlsConfig(conf, caClient);
        return config == null ? null : RatisHelper.setServerTlsConf((GrpcTlsConfig)config);
    }

    public static enum RaftServerStatus {
        NOT_LEADER,
        LEADER_AND_NOT_READY,
        LEADER_AND_READY;

    }
}

