/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="Deletion Service Metrics", context="ozone")
public final class DeletingServiceMetrics {
    public static final String METRICS_SOURCE_NAME = DeletingServiceMetrics.class.getSimpleName();
    private MetricsRegistry registry = new MetricsRegistry(METRICS_SOURCE_NAME);
    @Metric(value={"Total no. of deleted directories sent for purge"})
    private MutableGaugeLong numDirsSentForPurge;
    @Metric(value={"Total no. of sub-directories sent for purge"})
    private MutableGaugeLong numSubDirsSentForPurge;
    @Metric(value={"Total no. of sub-files sent for purge"})
    private MutableGaugeLong numSubFilesSentForPurge;
    @Metric(value={"Total no. of keys processed"})
    private MutableGaugeLong numKeysProcessed;
    @Metric(value={"Total no. of deleted keys sent for purge"})
    private MutableGaugeLong numKeysSentForPurge;
    @Metric(value={"Total no. of directories purged"})
    private MutableGaugeLong numDirsPurged;
    @Metric(value={"Total no. of subFiles moved to deletedTable"})
    private MutableGaugeLong numSubFilesMovedToDeletedTable;
    @Metric(value={"Total no. of subDirectories moved to deletedDirTable"})
    private MutableGaugeLong numSubDirsMovedToDeletedDirTable;
    @Metric(value={"Total no. of keys purged"})
    private MutableGaugeLong numKeysPurged;

    private DeletingServiceMetrics() {
    }

    public static DeletingServiceMetrics create() {
        return (DeletingServiceMetrics)DefaultMetricsSystem.instance().register(METRICS_SOURCE_NAME, "Metrics tracking the progress of deletion of directories and keys in the OM", (Object)new DeletingServiceMetrics());
    }

    public static void unregister() {
        DefaultMetricsSystem.instance().unregisterSource(METRICS_SOURCE_NAME);
    }

    public void incrNumDirsSentForPurge(long dirDel) {
        this.numDirsSentForPurge.incr(dirDel);
    }

    public void incrNumSubDirsSentForPurge(long delta) {
        this.numSubDirsSentForPurge.incr(delta);
    }

    public void incrNumSubFilesSentForPurge(long delta) {
        this.numSubFilesSentForPurge.incr(delta);
    }

    public void incrementDirectoryDeletionTotalMetrics(long dirDel, long dirMove, long filesMove) {
        this.incrNumDirsSentForPurge(dirDel);
        this.incrNumSubDirsSentForPurge(dirMove);
        this.incrNumSubFilesSentForPurge(filesMove);
    }

    public long getNumDirsSentForPurge() {
        return this.numDirsSentForPurge.value();
    }

    public long getNumSubDirsSentForPurge() {
        return this.numSubDirsSentForPurge.value();
    }

    public long getNumSubFilesSentForPurge() {
        return this.numSubFilesSentForPurge.value();
    }

    public void incrNumKeysProcessed(long keysProcessed) {
        this.numKeysProcessed.incr(keysProcessed);
    }

    public void incrNumKeysSentForPurge(long keysPurge) {
        this.numKeysSentForPurge.incr(keysPurge);
    }

    public void incrNumDirPurged(long dirPurged) {
        this.numDirsPurged.incr(dirPurged);
    }

    public void incrNumSubFilesMoved(long subKeys) {
        this.numSubFilesMovedToDeletedTable.incr(subKeys);
    }

    public void incrNumSubDirectoriesMoved(long subDirectories) {
        this.numSubDirsMovedToDeletedDirTable.incr(subDirectories);
    }

    public long getNumDirsPurged() {
        return this.numDirsPurged.value();
    }

    public long getNumSubFilesMovedToDeletedTable() {
        return this.numSubFilesMovedToDeletedTable.value();
    }

    public long getNumSubDirsMovedToDeletedDirTable() {
        return this.numSubDirsMovedToDeletedDirTable.value();
    }

    public void incrNumKeysPurged(long keysPurged) {
        this.numKeysPurged.incr(keysPurged);
    }

    @VisibleForTesting
    public void resetDirectoryMetrics() {
        this.numDirsPurged.set(0L);
        this.numSubFilesMovedToDeletedTable.set(0L);
        this.numSubDirsMovedToDeletedDirTable.set(0L);
        this.numDirsSentForPurge.set(0L);
        this.numSubDirsSentForPurge.set(0L);
        this.numSubFilesSentForPurge.set(0L);
    }
}

