/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.checksum.AbstractBlockChecksumComputer;
import org.apache.hadoop.ozone.client.checksum.BaseFileChecksumHelper;
import org.apache.hadoop.ozone.client.checksum.ECBlockChecksumComputer;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.security.token.Token;

public class ECFileChecksumHelper
extends BaseFileChecksumHelper {
    public ECFileChecksumHelper(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode checksumCombineMode, ClientProtocol rpcClient, OmKeyInfo keyInfo) throws IOException {
        super(volume, bucket, keyName, length, checksumCombineMode, rpcClient, keyInfo);
    }

    @Override
    protected AbstractBlockChecksumComputer getBlockChecksumComputer(List<ContainerProtos.ChunkInfo> chunkInfos, long blockLength) {
        return new ECBlockChecksumComputer(chunkInfos, this.getKeyInfo(), blockLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ContainerProtos.ChunkInfo> getChunkInfos(OmKeyLocationInfo keyLocationInfo) throws IOException {
        List chunks;
        Token token = keyLocationInfo.getToken();
        BlockID blockID = keyLocationInfo.getBlockID();
        Pipeline pipeline = keyLocationInfo.getPipeline();
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        ECReplicationConfig repConfig = (ECReplicationConfig)pipeline.getReplicationConfig();
        for (DatanodeDetails dn : pipeline.getNodes()) {
            int replicaIndex = pipeline.getReplicaIndex(dn);
            if (replicaIndex != 1 && replicaIndex <= repConfig.getData()) continue;
            nodes.add(dn);
        }
        pipeline = Pipeline.newBuilder((Pipeline)pipeline).setReplicationConfig((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE)).setNodes(nodes).build();
        XceiverClientSpi xceiverClientSpi = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initializing BlockInputStream for get key to access {}", (Object)blockID.getContainerID());
            }
            xceiverClientSpi = this.getXceiverClientFactory().acquireClientForReadData(pipeline);
            ContainerProtos.GetBlockResponseProto response = ContainerProtocolCalls.getBlock((XceiverClientSpi)xceiverClientSpi, (BlockID)blockID, (Token)token, (Map)pipeline.getReplicaIndexes());
            chunks = response.getBlockData().getChunksList();
        }
        finally {
            if (xceiverClientSpi != null) {
                this.getXceiverClientFactory().releaseClientForReadData(xceiverClientSpi, false);
            }
        }
        return chunks;
    }
}

