/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.reporters;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpan;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.Reporter;

public class CompositeReporter
implements Reporter {
    private final List<Reporter> reporters = new ArrayList<Reporter>();

    public CompositeReporter(Reporter ... reporters) {
        for (int i = 0; i < reporters.length; ++i) {
            this.reporters.add(reporters[i]);
        }
    }

    @Override
    public void report(JaegerSpan span) {
        for (Reporter reporter : this.reporters) {
            reporter.report(span);
        }
    }

    @Override
    public void close() {
        for (Reporter reporter : this.reporters) {
            reporter.close();
        }
    }

    public String toString() {
        return "CompositeReporter(reporters=" + this.reporters + ")";
    }
}

