/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerObjectFactory;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.propagation.TextMapCodec;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.utils.Utils;
import org.apache.hadoop.ozone.shaded.io.opentracing.SpanContext;

public class JaegerSpanContext
implements SpanContext {
    protected static final byte flagSampled = 1;
    protected static final byte flagDebug = 2;
    private final long traceIdLow;
    private final long traceIdHigh;
    private final long spanId;
    private final long parentId;
    private final byte flags;
    private final Map<String, String> baggage;
    private final String debugId;
    private final JaegerObjectFactory objectFactory;
    private final String traceIdAsString;
    private final String spanIdAsString;
    private String traceState;

    public JaegerSpanContext(long traceIdHigh, long traceIdLow, long spanId, long parentId, byte flags) {
        this(traceIdHigh, traceIdLow, spanId, parentId, flags, Collections.emptyMap(), null, new JaegerObjectFactory());
    }

    protected JaegerSpanContext(long traceIdHigh, long traceIdLow, long spanId, long parentId, byte flags, Map<String, String> baggage, String debugId, JaegerObjectFactory objectFactory) {
        if (baggage == null) {
            baggage = Collections.emptyMap();
        }
        this.traceIdLow = traceIdLow;
        this.traceIdHigh = traceIdHigh;
        this.spanId = spanId;
        this.parentId = parentId;
        this.flags = flags;
        this.baggage = baggage;
        this.debugId = debugId;
        this.objectFactory = objectFactory;
        this.traceIdAsString = this.convertTraceId();
        this.spanIdAsString = Utils.to16HexString(spanId);
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return new HashMap<String, String>(this.baggage).entrySet();
    }

    public String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    Map<String, String> baggage() {
        return this.baggage;
    }

    private String convertTraceId() {
        if (this.traceIdHigh == 0L) {
            return Utils.to16HexString(this.traceIdLow);
        }
        String hexStringHigh = Utils.to16HexString(this.traceIdHigh);
        String hexStringLow = Utils.to16HexString(this.traceIdLow);
        return hexStringHigh + hexStringLow;
    }

    public String getTraceId() {
        return this.traceIdAsString;
    }

    public long getTraceIdLow() {
        return this.traceIdLow;
    }

    public long getTraceIdHigh() {
        return this.traceIdHigh;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public byte getFlags() {
        return this.flags;
    }

    public String getTraceState() {
        return this.traceState;
    }

    public boolean isSampled() {
        return (this.flags & 1) == 1;
    }

    public boolean isDebug() {
        return (this.flags & 2) == 2;
    }

    public int baggageCount() {
        return this.baggage.size();
    }

    public String toString() {
        return TextMapCodec.contextAsString(this);
    }

    public JaegerSpanContext withBaggageItem(String key, String val) {
        HashMap<String, String> newBaggage = new HashMap<String, String>(this.baggage);
        if (val == null) {
            newBaggage.remove(key);
        } else {
            newBaggage.put(key, val);
        }
        return this.objectFactory.createSpanContext(this.traceIdHigh, this.traceIdLow, this.spanId, this.parentId, this.flags, newBaggage, this.debugId);
    }

    public JaegerSpanContext withBaggage(Map<String, String> newBaggage) {
        return this.objectFactory.createSpanContext(this.traceIdHigh, this.traceIdLow, this.spanId, this.parentId, this.flags, newBaggage, this.debugId);
    }

    public JaegerSpanContext withFlags(byte flags) {
        return this.objectFactory.createSpanContext(this.traceIdHigh, this.traceIdLow, this.spanId, this.parentId, flags, this.baggage, this.debugId);
    }

    public JaegerSpanContext withTraceState(String traceState) {
        JaegerSpanContext spanContext = this.objectFactory.createSpanContext(this.traceIdHigh, this.traceIdLow, this.spanId, this.parentId, this.flags, this.baggage, this.debugId);
        spanContext.traceState = traceState;
        return spanContext;
    }

    boolean hasTrace() {
        return (this.traceIdLow != 0L || this.traceIdHigh != 0L) && this.spanId != 0L;
    }

    String getDebugId() {
        return this.debugId;
    }

    @Override
    public String toTraceId() {
        return this.traceIdAsString;
    }

    @Override
    public String toSpanId() {
        return this.spanIdAsString;
    }
}

