/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant.impl;

import java.util.List;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.apache.hadoop.ozone.om.multitenant.BucketNameSpace;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.ImmutableList;

public class SingleVolumeTenantNamespace
implements BucketNameSpace {
    public static final String BUCKET_NS_PREFIX = "BucketNS-";
    private final String bucketNameSpaceID;
    private final List<OzoneObj> nsObjects;

    public SingleVolumeTenantNamespace(String id) {
        this(id, id);
    }

    public SingleVolumeTenantNamespace(String id, String volumeName) {
        this.bucketNameSpaceID = BUCKET_NS_PREFIX + id;
        this.nsObjects = ImmutableList.of(new OzoneObjInfo.Builder().setResType(OzoneObj.ResourceType.VOLUME).setStoreType(OzoneObj.StoreType.OZONE).setVolumeName(volumeName).build());
    }

    @Override
    public String getBucketNameSpaceID() {
        return this.bucketNameSpaceID;
    }

    @Override
    public List<OzoneObj> getBucketNameSpaceObjects() {
        return this.nsObjects;
    }

    @Override
    public void addBucketNameSpaceObject(OzoneObj e) {
        throw new UnsupportedOperationException("Cannot add an object to a single SingleVolumeTenantNamespace.");
    }

    @Override
    public SpaceUsageSource getSpaceUsage() {
        return null;
    }

    @Override
    public void setQuota(OzoneQuota quota) {
    }

    @Override
    public OzoneQuota getQuota() {
        return null;
    }
}

