/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class OmBucketArgs
extends WithMetadata
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private final Boolean isVersionEnabled;
    private final StorageType storageType;
    private final BucketEncryptionKeyInfo bekInfo;
    private final long quotaInBytes;
    private final long quotaInNamespace;
    private final boolean quotaInBytesSet;
    private final boolean quotaInNamespaceSet;
    private final DefaultReplicationConfig defaultReplicationConfig;
    private final String ownerName;

    private OmBucketArgs(Builder b) {
        super(b);
        this.volumeName = b.volumeName;
        this.bucketName = b.bucketName;
        this.isVersionEnabled = b.isVersionEnabled;
        this.storageType = b.storageType;
        this.ownerName = b.ownerName;
        this.defaultReplicationConfig = b.defaultReplicationConfig;
        this.quotaInBytesSet = b.quotaInBytesSet;
        this.quotaInBytes = this.quotaInBytesSet ? b.quotaInBytes : -1L;
        this.quotaInNamespaceSet = b.quotaInNamespaceSet;
        this.quotaInNamespace = this.quotaInNamespaceSet ? b.quotaInNamespace : -1L;
        this.bekInfo = b.bekInfo;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Boolean getIsVersionEnabled() {
        return this.isVersionEnabled;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public boolean hasQuotaInBytes() {
        return this.quotaInBytesSet;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public boolean hasQuotaInNamespace() {
        return this.quotaInNamespaceSet;
    }

    public DefaultReplicationConfig getDefaultReplicationConfig() {
        return this.defaultReplicationConfig;
    }

    public BucketEncryptionKeyInfo getBucketEncryptionKeyInfo() {
        return this.bekInfo;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("gdprEnabled", this.getMetadata().get("gdprEnabled"));
        auditMap.put("isVersionEnabled", String.valueOf(this.isVersionEnabled));
        if (this.storageType != null) {
            auditMap.put("storageType", this.storageType.name());
        }
        if (this.ownerName != null) {
            auditMap.put("owner", this.ownerName);
        }
        if (this.quotaInBytesSet && this.quotaInBytes > 0L || this.quotaInBytes != -1L) {
            auditMap.put("quotaInBytes", String.valueOf(this.quotaInBytes));
        }
        if (this.quotaInNamespaceSet && this.quotaInNamespace > 0L || this.quotaInNamespace != -1L) {
            auditMap.put("quotaInNamespace", String.valueOf(this.quotaInNamespace));
        }
        if (this.bekInfo != null) {
            auditMap.put("bucketEncryptionKey", this.bekInfo.getKeyName());
        }
        if (this.defaultReplicationConfig != null) {
            auditMap.put("replicationType", String.valueOf((Object)this.defaultReplicationConfig.getType()));
            auditMap.put("replicationConfig", this.defaultReplicationConfig.getReplicationConfig().getReplication());
        }
        return auditMap;
    }

    public OzoneManagerProtocolProtos.BucketArgs getProtobuf() {
        OzoneManagerProtocolProtos.BucketArgs.Builder builder = OzoneManagerProtocolProtos.BucketArgs.newBuilder();
        builder.setVolumeName(this.volumeName).setBucketName(this.bucketName);
        if (this.isVersionEnabled != null) {
            builder.setIsVersionEnabled(this.isVersionEnabled);
        }
        if (this.storageType != null) {
            builder.setStorageType(this.storageType.toProto());
        }
        if (this.quotaInBytesSet && (this.quotaInBytes > 0L || this.quotaInBytes == -1L)) {
            builder.setQuotaInBytes(this.quotaInBytes);
        }
        if (this.quotaInNamespaceSet && (this.quotaInNamespace > 0L || this.quotaInNamespace == -1L)) {
            builder.setQuotaInNamespace(this.quotaInNamespace);
        }
        if (this.defaultReplicationConfig != null) {
            builder.setDefaultReplicationConfig(this.defaultReplicationConfig.toProto());
        }
        if (this.ownerName != null) {
            builder.setOwnerName(this.ownerName);
        }
        if (this.bekInfo != null) {
            builder.setBekInfo(OMPBHelper.convert(this.bekInfo));
        }
        return builder.build();
    }

    public static OmBucketArgs getFromProtobuf(OzoneManagerProtocolProtos.BucketArgs bucketArgs) {
        WithMetadata.Builder builder = OmBucketArgs.newBuilder().setVolumeName(bucketArgs.getVolumeName()).setBucketName(bucketArgs.getBucketName()).addAllMetadata((Map)KeyValueUtil.getFromProtobuf(bucketArgs.getMetadataList()));
        if (bucketArgs.hasIsVersionEnabled()) {
            ((Builder)builder).setIsVersionEnabled(bucketArgs.getIsVersionEnabled());
        }
        if (bucketArgs.hasStorageType()) {
            ((Builder)builder).setStorageType(StorageType.valueOf(bucketArgs.getStorageType()));
        }
        if (bucketArgs.hasOwnerName()) {
            ((Builder)builder).setOwnerName(bucketArgs.getOwnerName());
        }
        if (bucketArgs.hasDefaultReplicationConfig()) {
            ((Builder)builder).setDefaultReplicationConfig(DefaultReplicationConfig.fromProto(bucketArgs.getDefaultReplicationConfig()));
        }
        if (bucketArgs.hasQuotaInBytes()) {
            ((Builder)builder).setQuotaInBytes(bucketArgs.getQuotaInBytes());
        }
        if (bucketArgs.hasQuotaInNamespace()) {
            ((Builder)builder).setQuotaInNamespace(bucketArgs.getQuotaInNamespace());
        }
        if (bucketArgs.hasBekInfo()) {
            ((Builder)builder).setBucketEncryptionKey(OMPBHelper.convert(bucketArgs.getBekInfo()));
        }
        return ((Builder)builder).build();
    }

    public static class Builder
    extends WithMetadata.Builder {
        private String volumeName;
        private String bucketName;
        private Boolean isVersionEnabled;
        private StorageType storageType;
        private boolean quotaInBytesSet = false;
        private long quotaInBytes = -1L;
        private boolean quotaInNamespaceSet = false;
        private long quotaInNamespace = -1L;
        private BucketEncryptionKeyInfo bekInfo;
        private DefaultReplicationConfig defaultReplicationConfig;
        private String ownerName;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setIsVersionEnabled(Boolean versionFlag) {
            this.isVersionEnabled = versionFlag;
            return this;
        }

        @Deprecated
        public Builder setBucketEncryptionKey(BucketEncryptionKeyInfo info) {
            if (info == null || info.getKeyName() != null) {
                this.bekInfo = info;
            }
            return this;
        }

        @Override
        public Builder addAllMetadata(Map<String, String> map) {
            super.addAllMetadata(map);
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setQuotaInBytes(long quota) {
            this.quotaInBytesSet = true;
            this.quotaInBytes = quota;
            return this;
        }

        public Builder setQuotaInNamespace(long quota) {
            this.quotaInNamespaceSet = true;
            this.quotaInNamespace = quota;
            return this;
        }

        public Builder setDefaultReplicationConfig(DefaultReplicationConfig defaultRepConfig) {
            this.defaultReplicationConfig = defaultRepConfig;
            return this;
        }

        public Builder setOwnerName(String owner) {
            this.ownerName = owner;
            return this;
        }

        public OmBucketArgs build() {
            Preconditions.checkNotNull(this.volumeName);
            Preconditions.checkNotNull(this.bucketName);
            return new OmBucketArgs(this);
        }
    }
}

