/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.hadoop.hdds.utils.Cache;
import org.apache.hadoop.ozone.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.ozone.shaded.com.google.common.cache.RemovalListener;
import org.apache.hadoop.ozone.shaded.com.google.common.cache.Weigher;

public class ResourceCache<K, V>
implements Cache<K, V> {
    private final org.apache.hadoop.ozone.shaded.com.google.common.cache.Cache<K, V> cache;

    public ResourceCache(Weigher<K, V> weigher, long limits, RemovalListener<K, V> listener) {
        Objects.requireNonNull(weigher);
        this.cache = listener == null ? CacheBuilder.newBuilder().maximumWeight(limits).weigher(weigher).build() : CacheBuilder.newBuilder().maximumWeight(limits).weigher(weigher).removalListener(listener).build();
    }

    @Override
    public V get(K key) {
        Objects.requireNonNull(key);
        return this.cache.getIfPresent(key);
    }

    @Override
    public void put(K key, V value) throws InterruptedException {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.cache.put(key, value);
    }

    @Override
    public void remove(K key) {
        Objects.requireNonNull(key);
        this.cache.invalidate(key);
    }

    @Override
    public void removeIf(Predicate<K> predicate) {
        Objects.requireNonNull(predicate);
        for (Object key : this.cache.asMap().keySet()) {
            if (!predicate.test(key)) continue;
            this.remove(key);
        }
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }
}

