/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.StreamBufferArgs;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.scm.storage.CommitWatcher;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class RatisBlockOutputStream
extends BlockOutputStream
implements Syncable {
    private final CommitWatcher commitWatcher;

    public RatisBlockOutputStream(BlockID blockID, long blockSize, XceiverClientFactory xceiverClientManager, Pipeline pipeline, BufferPool bufferPool, OzoneClientConfig config, Token<? extends TokenIdentifier> token, ContainerClientMetrics clientMetrics, StreamBufferArgs streamBufferArgs, Supplier<ExecutorService> blockOutputStreamResourceProvider) throws IOException {
        super(blockID, blockSize, xceiverClientManager, pipeline, bufferPool, config, token, clientMetrics, streamBufferArgs, blockOutputStreamResourceProvider);
        this.commitWatcher = new CommitWatcher(bufferPool, this.getXceiverClient());
    }

    @Override
    public long getTotalAckDataLength() {
        return this.commitWatcher.getTotalAckDataLength();
    }

    @VisibleForTesting
    public Map<Long, List<ChunkBuffer>> getCommitIndex2flushedDataMap() {
        return this.commitWatcher.getCommitIndexMap();
    }

    @Override
    void releaseBuffersOnException() {
        this.commitWatcher.releaseBuffersOnException();
    }

    @Override
    CompletableFuture<XceiverClientReply> sendWatchForCommit(long index) {
        return this.commitWatcher.watchForCommitAsync(index);
    }

    @Override
    void updateCommitInfo(XceiverClientReply reply, List<ChunkBuffer> buffers) {
        this.commitWatcher.updateCommitInfoMap(reply.getLogIndex(), buffers);
    }

    @Override
    void waitOnFlushFuture() throws InterruptedException, ExecutionException {
        CompletableFuture<Void> flushFuture = this.getLastFlushFuture();
        if (flushFuture != null) {
            flushFuture.get();
        }
    }

    @Override
    void cleanup() {
        this.commitWatcher.cleanup();
    }

    public void hflush() throws IOException {
        this.hsync();
    }

    public void hsync() throws IOException {
        if (!this.isClosed()) {
            this.handleFlush(false);
        }
    }
}

