/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.net.InnerNode;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeImpl;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerNodeImpl
extends NodeImpl
implements InnerNode {
    public static final Factory FACTORY = new Factory();
    private HashMap<String, Node> childrenMap = new LinkedHashMap<String, Node>();
    private int numOfLeaves;
    public static final Logger LOG = LoggerFactory.getLogger(InnerNodeImpl.class);

    protected InnerNodeImpl(String name, String location, InnerNode parent, int level, int cost) {
        super(name, location, parent, level, cost);
    }

    protected InnerNodeImpl(String name, String location, int level, int cost, HashMap<String, Node> childrenMap, int numOfLeaves) {
        super(name, location, null, level, cost);
        this.childrenMap = childrenMap;
        this.numOfLeaves = numOfLeaves;
    }

    private int getNumOfChildren() {
        return this.childrenMap.size();
    }

    @Override
    public int getNumOfLeaves() {
        return this.numOfLeaves;
    }

    public HashMap<String, Node> getChildrenMap() {
        return this.childrenMap;
    }

    @Override
    public int getNumOfNodes(int level) {
        Preconditions.checkArgument(level > 0);
        int count = 0;
        if (level == 1) {
            ++count;
        } else if (level == 2) {
            count += this.getNumOfChildren();
        } else {
            for (Node node : this.childrenMap.values()) {
                if (node instanceof InnerNode) {
                    count += ((InnerNode)node).getNumOfNodes(level - 1);
                    continue;
                }
                throw new RuntimeException("Cannot support Level:" + level + " on this node " + this.toString());
            }
        }
        return count;
    }

    @Override
    public List<Node> getNodes(int level) {
        Preconditions.checkArgument(level > 0);
        ArrayList<Node> result = new ArrayList<Node>();
        if (level == 1) {
            result.add(this);
        } else if (level == 2) {
            result.addAll(this.childrenMap.values());
        } else {
            for (Node node : this.childrenMap.values()) {
                if (node instanceof InnerNode) {
                    result.addAll(((InnerNode)node).getNodes(level - 1));
                    continue;
                }
                throw new RuntimeException("Cannot support Level:" + level + " on this node " + this.toString());
            }
        }
        return result;
    }

    private boolean isLeafParent() {
        if (this.childrenMap.isEmpty()) {
            return true;
        }
        Node child = this.childrenMap.values().iterator().next();
        return !(child instanceof InnerNode);
    }

    private boolean isParent(Node node) {
        return node.getNetworkLocation().equals(this.getNetworkFullPath());
    }

    @Override
    public boolean add(Node node) {
        if (!this.isAncestor(node)) {
            throw new IllegalArgumentException(node.getNetworkName() + ", which is located at " + node.getNetworkLocation() + ", is not a descendant of " + this.getNetworkFullPath());
        }
        if (this.isParent(node)) {
            node.setParent(this);
            node.setLevel(this.getLevel() + 1);
            Node current = this.childrenMap.put(node.getNetworkName(), node);
            if (current != null) {
                return false;
            }
        } else {
            String ancestorName = this.getNextLevelAncestorName(node);
            InnerNode childNode = (InnerNode)this.childrenMap.get(ancestorName);
            if (childNode == null) {
                childNode = this.createChildNode(ancestorName);
                this.childrenMap.put(childNode.getNetworkName(), childNode);
            }
            if (!childNode.add(node)) {
                return false;
            }
        }
        ++this.numOfLeaves;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void remove(Node node) {
        if (!this.isAncestor(node)) {
            throw new IllegalArgumentException(node.getNetworkName() + ", which is located at " + node.getNetworkLocation() + ", is not a descendant of " + this.getNetworkFullPath());
        }
        if (this.isParent(node)) {
            if (!this.childrenMap.containsKey(node.getNetworkName())) throw new RuntimeException("Should not come to here. Node:" + node.getNetworkFullPath() + ", Parent:" + this.getNetworkFullPath());
            this.childrenMap.remove(node.getNetworkName());
            node.setParent(null);
        } else {
            String ancestorName = this.getNextLevelAncestorName(node);
            InnerNodeImpl childNode = (InnerNodeImpl)this.childrenMap.get(ancestorName);
            Preconditions.checkNotNull(childNode, "InnerNode is deleted before leaf");
            childNode.remove(node);
            if (childNode.getNumOfChildren() == 0) {
                this.childrenMap.remove(ancestorName);
            }
        }
        --this.numOfLeaves;
    }

    @Override
    public Node getNode(String loc) {
        String[] path;
        Node child;
        if (loc == null) {
            return null;
        }
        String fullPath = this.getNetworkFullPath();
        if (loc.equalsIgnoreCase(fullPath)) {
            return this;
        }
        if (fullPath.equals("/")) {
            if (loc.startsWith("/")) {
                loc = loc.substring(1);
            }
        } else if (loc.startsWith(fullPath)) {
            loc = loc.substring(fullPath.length());
            loc = loc.substring(1);
        }
        if ((child = this.childrenMap.get((path = loc.split("/", 2))[0])) == null) {
            return null;
        }
        if (path.length == 1) {
            return child;
        }
        if (child instanceof InnerNode) {
            return ((InnerNode)child).getNode(path[1]);
        }
        return null;
    }

    @Override
    public Node getLeaf(int leafIndex) {
        Preconditions.checkArgument(leafIndex >= 0);
        if (this.isLeafParent()) {
            if (leafIndex >= this.getNumOfChildren()) {
                return null;
            }
            return this.getChildNode(leafIndex);
        }
        for (Node node : this.childrenMap.values()) {
            InnerNodeImpl child = (InnerNodeImpl)node;
            int leafCount = child.getNumOfLeaves();
            if (leafIndex < leafCount) {
                return child.getLeaf(leafIndex);
            }
            leafIndex -= leafCount;
        }
        return null;
    }

    @Override
    public Node getLeaf(int leafIndex, List<String> excludedScopes, Collection<Node> excludedNodes, int ancestorGen) {
        Preconditions.checkArgument(leafIndex >= 0 && ancestorGen >= 0);
        if (this.isLeafParent()) {
            return this.getLeafOnLeafParent(leafIndex, excludedScopes, excludedNodes);
        }
        int maxLevel = NodeSchemaManager.getInstance().getMaxLevel();
        int currentGen = maxLevel - this.getLevel() - 1;
        Map<Node, Integer> countMap = this.getAncestorCountMap(excludedNodes, ancestorGen, currentGen);
        Map<String, Integer> excludedNodeCount = this.getExcludedScopeNodeCount(excludedScopes);
        for (Node child : this.childrenMap.values()) {
            int leafCount = child.getNumOfLeaves();
            for (Map.Entry<String, Integer> entry : excludedNodeCount.entrySet()) {
                if (!entry.getKey().startsWith(child.getNetworkFullPath())) continue;
                leafCount -= entry.getValue().intValue();
            }
            Integer count = countMap.get(child);
            if (count != null) {
                leafCount -= count.intValue();
            }
            if (leafIndex < leafCount) {
                return ((InnerNode)child).getLeaf(leafIndex, excludedScopes, excludedNodes, ancestorGen);
            }
            leafIndex -= leafCount;
        }
        return null;
    }

    @Override
    public HddsProtos.NetworkNode toProtobuf(int clientVersion) {
        HddsProtos.InnerNode.Builder innerNode = HddsProtos.InnerNode.newBuilder().setNumOfLeaves(this.numOfLeaves).setNodeTopology(NodeImpl.toProtobuf(this.getNetworkName(), this.getNetworkLocation(), this.getLevel(), this.getCost()));
        if (this.childrenMap != null && !this.childrenMap.isEmpty()) {
            for (Map.Entry<String, Node> entry : this.childrenMap.entrySet()) {
                if (entry.getValue() == null) continue;
                HddsProtos.ChildrenMap childrenMapProto = HddsProtos.ChildrenMap.newBuilder().setNetworkName(entry.getKey()).setNetworkNode(entry.getValue().toProtobuf(clientVersion)).build();
                innerNode.addChildrenMap(childrenMapProto);
            }
        }
        innerNode.build();
        HddsProtos.NetworkNode networkNode = HddsProtos.NetworkNode.newBuilder().setInnerNode(innerNode).build();
        return networkNode;
    }

    public static InnerNode fromProtobuf(HddsProtos.InnerNode innerNode) {
        Builder builder = new Builder();
        if (innerNode.hasNodeTopology()) {
            HddsProtos.NodeTopology nodeTopology = innerNode.getNodeTopology();
            if (nodeTopology.hasName()) {
                builder.setName(nodeTopology.getName());
            }
            if (nodeTopology.hasLocation()) {
                builder.setLocation(nodeTopology.getLocation());
            }
            if (nodeTopology.hasLevel()) {
                builder.setLevel(nodeTopology.getLevel());
            }
            if (nodeTopology.hasCost()) {
                builder.setCost(nodeTopology.getCost());
            }
        }
        if (!innerNode.getChildrenMapList().isEmpty()) {
            builder.setChildrenMap(innerNode.getChildrenMapList());
        }
        if (innerNode.hasNumOfLeaves()) {
            builder.setNumOfLeaves(innerNode.getNumOfLeaves());
        }
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InnerNodeImpl innerNode = (InnerNodeImpl)o;
        return this.getNetworkName().equals(innerNode.getNetworkName()) && this.getNetworkLocation().equals(innerNode.getNetworkLocation()) && this.getLevel() == innerNode.getLevel() && this.getCost() == innerNode.getCost() && this.numOfLeaves == innerNode.numOfLeaves && this.childrenMap.size() == innerNode.childrenMap.size() && this.childrenMap.equals(innerNode.childrenMap);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private Map<Node, Integer> getAncestorCountMap(Collection<Node> nodes, int genToExclude, int genToReturn) {
        Preconditions.checkState(genToExclude >= 0);
        Preconditions.checkState(genToReturn >= 0);
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyMap();
        }
        if (genToReturn < genToExclude) {
            genToExclude = genToReturn;
        }
        HashMap<Node, Node> ancestorMap = new HashMap<Node, Node>();
        for (Node node : nodes) {
            Node ancestorToExclude = node.getAncestor(genToExclude);
            Node ancestorToReturn = node.getAncestor(genToReturn);
            if (ancestorToExclude == null || ancestorToReturn == null) {
                LOG.warn("Ancestor not found, node: {}, generation to exclude: {}, generation to return: {}", new Object[]{node.getNetworkFullPath(), genToExclude, genToReturn});
                continue;
            }
            ancestorMap.put(ancestorToExclude, ancestorToReturn);
        }
        HashMap<Node, Integer> countMap = new HashMap<Node, Integer>();
        for (Map.Entry entry : ancestorMap.entrySet()) {
            countMap.compute((Node)entry.getValue(), (key, n) -> (n == null ? 0 : n) + ((Node)entry.getKey()).getNumOfLeaves());
        }
        return countMap;
    }

    private Node getLeafOnLeafParent(int leafIndex, List<String> excludedScopes, Collection<Node> excludedNodes) {
        Preconditions.checkArgument(this.isLeafParent() && leafIndex >= 0);
        if (leafIndex >= this.getNumOfChildren()) {
            return null;
        }
        for (Node node : this.childrenMap.values()) {
            if (excludedNodes != null && excludedNodes.contains(node)) continue;
            if (excludedScopes != null && !excludedScopes.isEmpty()) {
                if (excludedScopes.stream().anyMatch(node::isDescendant)) continue;
            }
            if (leafIndex == 0) {
                return node;
            }
            --leafIndex;
        }
        return null;
    }

    private String getNextLevelAncestorName(Node n) {
        int index;
        int parentPathLen = this.getNetworkFullPath().length();
        String name = n.getNetworkLocation().substring(parentPathLen);
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if ((index = name.indexOf(47)) != -1) {
            name = name.substring(0, index);
        }
        return name;
    }

    private InnerNodeImpl createChildNode(String name) {
        int childLevel = this.getLevel() + 1;
        int cost = NodeSchemaManager.getInstance().getCost(childLevel);
        return new InnerNodeImpl(name, this.getNetworkFullPath(), (InnerNode)this, childLevel, cost);
    }

    private Node getChildNode(int index) {
        Iterator<Node> iterator2 = this.childrenMap.values().iterator();
        Node node = null;
        while (index >= 0 && iterator2.hasNext()) {
            node = iterator2.next();
            --index;
        }
        return node;
    }

    private Map<String, Integer> getExcludedScopeNodeCount(List<String> excludedScopes) {
        HashMap<String, Integer> nodeCounts = new HashMap<String, Integer>();
        if (excludedScopes == null || excludedScopes.isEmpty()) {
            return nodeCounts;
        }
        Iterator<String> iterator2 = excludedScopes.iterator();
        while (iterator2.hasNext()) {
            String scope;
            Node excludedScopeNode = this.getNode(scope = iterator2.next());
            nodeCounts.put(scope, excludedScopeNode == null ? 0 : excludedScopeNode.getNumOfLeaves());
        }
        return nodeCounts;
    }

    public static class Builder {
        private String name;
        private String location;
        private int cost;
        private int level;
        private HashMap<String, Node> childrenMap = new LinkedHashMap<String, Node>();
        private int numOfLeaves;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCost(int cost) {
            this.cost = cost;
            return this;
        }

        public Builder setLevel(int level) {
            this.level = level;
            return this;
        }

        public Builder setChildrenMap(List<HddsProtos.ChildrenMap> childrenMapList) {
            LinkedHashMap<String, Node> newChildrenMap = new LinkedHashMap<String, Node>();
            for (HddsProtos.ChildrenMap childrenMapProto : childrenMapList) {
                String networkName = childrenMapProto.hasNetworkName() ? childrenMapProto.getNetworkName() : null;
                Node node = childrenMapProto.hasNetworkNode() ? Node.fromProtobuf(childrenMapProto.getNetworkNode()) : null;
                newChildrenMap.put(networkName, node);
            }
            this.childrenMap = newChildrenMap;
            return this;
        }

        public Builder setNumOfLeaves(int numOfLeaves) {
            this.numOfLeaves = numOfLeaves;
            return this;
        }

        public InnerNodeImpl build() {
            return new InnerNodeImpl(this.name, this.location, this.level, this.cost, this.childrenMap, this.numOfLeaves);
        }
    }

    protected static class Factory
    implements InnerNode.Factory<InnerNodeImpl> {
        protected Factory() {
        }

        @Override
        public InnerNodeImpl newInnerNode(String name, String location, InnerNode parent, int level, int cost) {
            return new InnerNodeImpl(name, location, parent, level, cost);
        }
    }
}

