/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.ozone.OzoneFsDelete;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class OzoneFsShell
extends FsShell {
    private static final String OZONE_USAGE_PREFIX = "Usage: ozone fs [generic options]";

    public OzoneFsShell() {
        this(null);
    }

    public OzoneFsShell(OzoneConfiguration conf) {
        super((Configuration)conf);
    }

    protected void registerCommands(CommandFactory factory2) {
        if (((Object)((Object)this)).getClass().equals(OzoneFsShell.class)) {
            factory2.registerCommands(FsCommand.class);
            factory2.registerCommands(OzoneFsDelete.class);
        }
    }

    protected String getUsagePrefix() {
        return OZONE_USAGE_PREFIX;
    }

    public static void main(String[] argv) throws Exception {
        OzoneFsShell shell = OzoneFsShell.newShellInstance();
        OzoneConfiguration conf = new OzoneConfiguration();
        TracingUtil.initTracing("FsShell", conf);
        conf.setQuietMode(false);
        shell.setConf(conf);
        String spanName = "ozone fs " + String.join((CharSequence)" ", argv);
        int res = TracingUtil.executeInNewSpan(spanName, () -> shell.execute(argv));
        System.exit(res);
    }

    private int execute(String[] argv) throws Exception {
        try {
            int n = ToolRunner.run((Tool)this, (String[])argv);
            return n;
        }
        finally {
            this.close();
        }
    }

    protected static OzoneFsShell newShellInstance() {
        return new OzoneFsShell();
    }

    @VisibleForTesting
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }
}

