/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.tracing.GrpcServerInterceptor;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.replication.ContainerImporter;
import org.apache.hadoop.ozone.container.replication.GrpcReplicationService;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptors;
import org.apache.ratis.thirdparty.io.grpc.ServerServiceDefinition;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.ClientAuth;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationServer {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationServer.class);
    private Server server;
    private SecurityConfig secConf;
    private CertificateClient caClient;
    private ContainerController controller;
    private int port;
    private final ContainerImporter importer;
    private ThreadPoolExecutor executor;

    public ReplicationServer(ContainerController controller, ReplicationConfig replicationConfig, SecurityConfig secConf, CertificateClient caClient, ContainerImporter importer, String threadNamePrefix) {
        this.secConf = secConf;
        this.caClient = caClient;
        this.controller = controller;
        this.importer = importer;
        this.port = replicationConfig.getPort();
        int replicationServerWorkers = replicationConfig.getReplicationMaxStreams();
        int replicationQueueLimit = replicationConfig.getReplicationQueueLimit();
        LOG.info("Initializing replication server with thread count = {} queue length = {}", (Object)replicationConfig.getReplicationMaxStreams(), (Object)replicationConfig.getReplicationQueueLimit());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadNamePrefix + "ReplicationContainerReader-%d").build();
        this.executor = new ThreadPoolExecutor(replicationServerWorkers, replicationServerWorkers, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(replicationQueueLimit), threadFactory);
        this.init();
    }

    public void init() {
        GrpcReplicationService grpcReplicationService = new GrpcReplicationService(new OnDemandContainerReplicationSource(this.controller), this.importer);
        NettyServerBuilder nettyServerBuilder = (NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).maxInboundMessageSize(0x2000000).addService(ServerInterceptors.intercept((ServerServiceDefinition)grpcReplicationService.bindServiceWithZeroCopy(), (ServerInterceptor[])new ServerInterceptor[]{new GrpcServerInterceptor()}))).executor((Executor)this.executor);
        if (this.secConf.isSecurityEnabled() && this.secConf.isGrpcTlsEnabled()) {
            try {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManager)this.caClient.getKeyManager());
                sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)this.secConf.getGrpcSslProvider());
                sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
                sslContextBuilder.trustManager((TrustManager)this.caClient.getTrustManager());
                nettyServerBuilder.sslContext(sslContextBuilder.build());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Unable to setup TLS for secure datanode replication GRPC endpoint.", ex);
            }
        }
        this.server = nettyServerBuilder.build();
    }

    public void start() throws IOException {
        this.server.start();
        this.port = this.server.getPort();
        LOG.info("{} is started using port {}", (Object)this.getClass().getSimpleName(), (Object)this.port);
    }

    public void stop() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            this.server.shutdown().awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOG.warn("{} couldn't be stopped gracefully", (Object)this.getClass().getSimpleName());
            Thread.currentThread().interrupt();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPoolSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Pool size must be positive.");
        }
        int currentCorePoolSize = this.executor.getCorePoolSize();
        if (size > currentCorePoolSize) {
            this.executor.setMaximumPoolSize(size);
            this.executor.setCorePoolSize(size);
        } else {
            this.executor.setCorePoolSize(size);
            this.executor.setMaximumPoolSize(size);
        }
    }

    @VisibleForTesting
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @ConfigGroup(prefix="hdds.datanode.replication")
    public static final class ReplicationConfig {
        public static final String PREFIX = "hdds.datanode.replication";
        public static final String STREAMS_LIMIT_KEY = "streams.limit";
        public static final String QUEUE_LIMIT = "queue.limit";
        public static final String REPLICATION_STREAMS_LIMIT_KEY = "hdds.datanode.replication.streams.limit";
        public static final int REPLICATION_MAX_STREAMS_DEFAULT = 10;
        private static final String OUTOFSERVICE_FACTOR_KEY = "outofservice.limit.factor";
        private static final double OUTOFSERVICE_FACTOR_MIN = 1.0;
        static final double OUTOFSERVICE_FACTOR_DEFAULT = 2.0;
        private static final String OUTOFSERVICE_FACTOR_DEFAULT_VALUE = "2.0";
        private static final double OUTOFSERVICE_FACTOR_MAX = 10.0;
        static final String REPLICATION_OUTOFSERVICE_FACTOR_KEY = "hdds.datanode.replication.outofservice.limit.factor";
        @Config(key="streams.limit", type=ConfigType.INT, defaultValue="10", tags={ConfigTag.DATANODE}, description="The maximum number of replication commands a single datanode can execute simultaneously")
        private int replicationMaxStreams = 10;
        @Config(key="queue.limit", type=ConfigType.INT, defaultValue="4096", tags={ConfigTag.DATANODE}, description="The maximum number of queued requests for container replication")
        private int replicationQueueLimit = 4096;
        @Config(key="port", defaultValue="9886", description="Port used for the server2server replication server", tags={ConfigTag.DATANODE, ConfigTag.MANAGEMENT})
        private int port;
        @Config(key="outofservice.limit.factor", type=ConfigType.DOUBLE, defaultValue="2.0", tags={ConfigTag.DATANODE, ConfigTag.SCM}, description="Decommissioning and maintenance nodes can handle morereplication commands than in-service nodes due to reduced load. This multiplier determines the increased queue capacity and executor pool size.")
        private double outOfServiceFactor = 2.0;

        public double getOutOfServiceFactor() {
            return this.outOfServiceFactor;
        }

        public int scaleOutOfServiceLimit(int original) {
            return (int)Math.ceil((double)original * this.outOfServiceFactor);
        }

        public int getPort() {
            return this.port;
        }

        public ReplicationConfig setPort(int portParam) {
            this.port = portParam;
            return this;
        }

        public int getReplicationMaxStreams() {
            return this.replicationMaxStreams;
        }

        public void setReplicationMaxStreams(int replicationMaxStreams) {
            this.replicationMaxStreams = replicationMaxStreams;
        }

        public int getReplicationQueueLimit() {
            return this.replicationQueueLimit;
        }

        public void setReplicationQueueLimit(int limit) {
            this.replicationQueueLimit = limit;
        }

        @PostConstruct
        public void validate() {
            if (this.replicationMaxStreams < 1) {
                LOG.warn("hdds.datanode.replication.streams.limit must be greater than zero and was set to {}. Defaulting to {}", (Object)this.replicationMaxStreams, (Object)10);
                this.replicationMaxStreams = 10;
            }
            if (this.outOfServiceFactor < 1.0 || this.outOfServiceFactor > 10.0) {
                LOG.warn("{} must be between {} and {} but was set to {}. Defaulting to {}", new Object[]{REPLICATION_OUTOFSERVICE_FACTOR_KEY, 1.0, 10.0, this.outOfServiceFactor, 2.0});
                this.outOfServiceFactor = 2.0;
            }
        }
    }
}

