/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.common.utils.ContainerCache;
import org.apache.hadoop.ozone.container.common.utils.DatanodeStoreCache;
import org.apache.hadoop.ozone.container.common.utils.RawDB;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaOneImpl;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaThreeImpl;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaTwoImpl;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static DatanodeStore getUncachedDatanodeStore(String containerDBPath, String schemaVersion, ConfigurationSource conf, boolean readOnly) throws IOException {
        AbstractDatanodeStore store;
        if (KeyValueContainerUtil.isSameSchemaVersion(schemaVersion, "1")) {
            store = new DatanodeStoreSchemaOneImpl(conf, containerDBPath, readOnly);
        } else if (KeyValueContainerUtil.isSameSchemaVersion(schemaVersion, "2")) {
            store = new DatanodeStoreSchemaTwoImpl(conf, containerDBPath, readOnly);
        } else if (KeyValueContainerUtil.isSameSchemaVersion(schemaVersion, "3")) {
            store = new DatanodeStoreSchemaThreeImpl(conf, containerDBPath, readOnly);
        } else {
            throw new IllegalArgumentException("Unrecognized database schema version: " + schemaVersion);
        }
        return store;
    }

    public static DatanodeStore getUncachedDatanodeStore(KeyValueContainerData containerData, ConfigurationSource conf, boolean readOnly) throws IOException {
        return BlockUtils.getUncachedDatanodeStore(containerData.getDbFile().getAbsolutePath(), containerData.getSchemaVersion(), conf, readOnly);
    }

    public static DBHandle getDB(KeyValueContainerData containerData, ConfigurationSource conf) throws StorageContainerException {
        Preconditions.checkNotNull((Object)containerData);
        Preconditions.checkNotNull((Object)containerData.getDbFile());
        String containerDBPath = containerData.getDbFile().getAbsolutePath();
        try {
            if (containerData.hasSchema("3")) {
                DatanodeStoreCache cache = DatanodeStoreCache.getInstance();
                Preconditions.checkNotNull((Object)cache);
                return cache.getDB(containerDBPath, conf);
            }
            ContainerCache cache = ContainerCache.getInstance(conf);
            Preconditions.checkNotNull((Object)((Object)cache));
            return cache.getDB(containerData.getContainerID(), containerData.getContainerDBType(), containerDBPath, containerData.getSchemaVersion(), conf);
        }
        catch (IOException ex) {
            StorageVolumeUtil.onFailure(containerData.getVolume());
            String message = String.format("Error opening DB. Container:%s ContainerPath:%s", containerData.getContainerID(), containerData.getDbFile().getPath());
            throw new StorageContainerException(message, ContainerProtos.Result.UNABLE_TO_READ_METADATA_DB);
        }
    }

    public static void removeDB(KeyValueContainerData container, ConfigurationSource conf) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)container.getDbFile());
        Preconditions.checkState((!container.hasSchema("3") ? 1 : 0) != 0);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        cache.removeDB(container.getDbFile().getAbsolutePath());
    }

    public static void shutdownCache(ConfigurationSource config) {
        ContainerCache.getInstance(config).shutdownCache();
        DatanodeStoreCache.getInstance().shutdownCache();
    }

    public static void addDB(DatanodeStore store, String containerDBPath, ConfigurationSource conf, String schemaVersion) {
        if (KeyValueContainerUtil.isSameSchemaVersion(schemaVersion, "3")) {
            DatanodeStoreCache cache = DatanodeStoreCache.getInstance();
            Preconditions.checkNotNull((Object)cache);
            cache.addDB(containerDBPath, new RawDB(store, containerDBPath));
        } else {
            ContainerCache cache = ContainerCache.getInstance(conf);
            Preconditions.checkNotNull((Object)((Object)cache));
            cache.addDB(containerDBPath, new ReferenceCountedDB(store, containerDBPath));
        }
    }

    public static BlockData getBlockData(byte[] bytes) throws IOException {
        try {
            ContainerProtos.BlockData blockData = ContainerProtos.BlockData.parseFrom((byte[])bytes);
            return BlockData.getFromProtoBuf((ContainerProtos.BlockData)blockData);
        }
        catch (IOException e) {
            throw new StorageContainerException("Failed to parse block data from the bytes array.", ContainerProtos.Result.NO_SUCH_BLOCK);
        }
    }

    public static void verifyBCSId(Container container, BlockID blockID) throws IOException {
        long bcsId = blockID.getBlockCommitSequenceId();
        Preconditions.checkNotNull((Object)blockID, (Object)"BlockID cannot be null");
        Preconditions.checkNotNull((Object)container, (Object)"Container cannot be null");
        long containerBCSId = container.getBlockCommitSequenceId();
        if (containerBCSId < bcsId) {
            throw new StorageContainerException("Unable to find the block with bcsID " + bcsId + " .Container " + ((ContainerData)container.getContainerData()).getContainerID() + " bcsId is " + containerBCSId + ".", ContainerProtos.Result.UNKNOWN_BCSID);
        }
    }

    public static void verifyReplicaIdx(Container container, BlockID blockID) throws IOException {
        Integer containerReplicaIndex = ((ContainerData)container.getContainerData()).getReplicaIndex();
        Integer blockReplicaIndex = blockID.getReplicaIndex();
        if (containerReplicaIndex > 0 && blockReplicaIndex != null && blockReplicaIndex != 0 && !containerReplicaIndex.equals(blockReplicaIndex)) {
            throw new StorageContainerException("Unable to find the Container with replicaIdx " + blockID.getReplicaIndex() + ". Container " + ((ContainerData)container.getContainerData()).getContainerID() + " replicaIdx is " + containerReplicaIndex + ".", ContainerProtos.Result.CONTAINER_NOT_FOUND);
        }
    }

    public static void removeContainerFromDB(KeyValueContainerData containerData, ConfigurationSource conf) throws IOException {
        try (DBHandle db = BlockUtils.getDB(containerData, conf);){
            Preconditions.checkState((boolean)(db.getStore() instanceof DatanodeStoreSchemaThreeImpl));
            ((DatanodeStoreSchemaThreeImpl)db.getStore()).removeKVContainerData(containerData.getContainerID());
        }
    }

    public static void dumpKVContainerDataToFiles(KeyValueContainerData containerData, ConfigurationSource conf) throws IOException {
        try (DBHandle db = BlockUtils.getDB(containerData, conf);){
            Preconditions.checkState((boolean)(db.getStore() instanceof DatanodeStoreSchemaThreeImpl));
            DatanodeStoreSchemaThreeImpl store = (DatanodeStoreSchemaThreeImpl)db.getStore();
            long containerID = containerData.getContainerID();
            File metaDir = new File(containerData.getMetadataPath());
            File dumpDir = DatanodeStoreSchemaThreeImpl.getDumpDir(metaDir);
            BlockUtils.deleteAllDumpFiles(dumpDir);
            try {
                if (!dumpDir.mkdirs() && !dumpDir.exists()) {
                    throw new IOException("Failed to create dir " + dumpDir.getAbsolutePath() + " for container " + containerID + " to dump metadata to files");
                }
                store.dumpKVContainerData(containerID, dumpDir);
            }
            catch (IOException e) {
                BlockUtils.deleteAllDumpFiles(dumpDir);
                throw new StorageContainerException("Failed to dump metadata for container " + containerID, (Throwable)e, ContainerProtos.Result.EXPORT_CONTAINER_METADATA_FAILED);
            }
        }
    }

    public static void loadKVContainerDataFromFiles(KeyValueContainerData containerData, ConfigurationSource conf) throws IOException {
        try (DBHandle db = BlockUtils.getDB(containerData, conf);){
            Preconditions.checkState((boolean)(db.getStore() instanceof DatanodeStoreSchemaThreeImpl));
            DatanodeStoreSchemaThreeImpl store = (DatanodeStoreSchemaThreeImpl)db.getStore();
            long containerID = containerData.getContainerID();
            File metaDir = new File(containerData.getMetadataPath());
            File dumpDir = DatanodeStoreSchemaThreeImpl.getDumpDir(metaDir);
            try {
                store.loadKVContainerData(dumpDir);
            }
            catch (IOException e) {
                store.removeKVContainerData(containerID);
                throw new StorageContainerException("Failed to load metadata from files for container " + containerID, (Throwable)e, ContainerProtos.Result.IMPORT_CONTAINER_METADATA_FAILED);
            }
            finally {
                BlockUtils.deleteAllDumpFiles(dumpDir);
            }
        }
    }

    public static void deleteAllDumpFiles(File dumpDir) throws IOException {
        try {
            FileUtils.deleteDirectory((File)dumpDir);
        }
        catch (IOException e) {
            throw new IOException("Failed to delete dump files under " + dumpDir.getAbsolutePath(), e);
        }
    }
}

