/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.ozone.container.common.utils.DatanodeStoreCache;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbVolume
extends StorageVolume {
    private static final Logger LOG = LoggerFactory.getLogger(DbVolume.class);
    public static final String DB_VOLUME_DIR = "db";
    private final Map<String, String> hddsDbStorePathMap = new HashMap<String, String>();

    protected DbVolume(Builder b) throws IOException {
        super(b);
        if (!b.getFailedVolume() && this.getVolumeInfo().isPresent()) {
            LOG.info("Creating DbVolume: {} of storage type: {}, {}", new Object[]{this.getStorageDir(), b.getStorageType(), this.getCurrentUsage()});
            this.initialize();
        }
    }

    @Override
    protected void initializeImpl() throws IOException {
        super.initializeImpl();
        this.scanForDbStorePaths();
    }

    @Override
    public void failVolume() {
        super.failVolume();
        this.closeAllDbStore();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.closeAllDbStore();
    }

    public void addHddsDbStorePath(String id, String dbPath) {
        this.hddsDbStorePathMap.put(id, dbPath);
    }

    public Set<String> getHddsVolumeIDs() {
        return this.hddsDbStorePathMap.keySet();
    }

    private void scanForDbStorePaths() throws IOException {
        if (!this.getStorageState().equals((Object)StorageVolume.VolumeState.NORMAL)) {
            return;
        }
        File clusterIdDir = new File(this.getStorageDir(), this.getClusterID());
        if (!clusterIdDir.exists()) {
            return;
        }
        File[] subdirs = clusterIdDir.listFiles(File::isDirectory);
        if (subdirs == null) {
            throw new IOException("Failed to do listFiles for " + clusterIdDir.getAbsolutePath());
        }
        this.hddsDbStorePathMap.clear();
        for (File subdir : subdirs) {
            String storageID = subdir.getName();
            File storageIdDir = new File(clusterIdDir, subdir.getName());
            this.hddsDbStorePathMap.put(storageID, new File(storageIdDir, "container.db").getAbsolutePath());
        }
    }

    private void closeAllDbStore() {
        if (this.getClusterID() == null) {
            return;
        }
        File clusterIdDir = new File(this.getStorageDir(), this.getClusterID());
        if (clusterIdDir.exists()) {
            for (String containerDBPath : this.hddsDbStorePathMap.values()) {
                DatanodeStoreCache.getInstance().removeDB(containerDBPath);
            }
        }
    }

    public static class Builder
    extends StorageVolume.Builder<Builder> {
        public Builder(String volumeRootStr) {
            super(volumeRootStr, DbVolume.DB_VOLUME_DIR);
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public DbVolume build() throws IOException {
            return new DbVolume(this);
        }
    }
}

