/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.datanode;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.states.DatanodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitDatanodeState
implements DatanodeState,
Callable<DatanodeStateMachine.DatanodeStates> {
    static final Logger LOG = LoggerFactory.getLogger(InitDatanodeState.class);
    private final SCMConnectionManager connectionManager;
    private final ConfigurationSource conf;
    private final StateContext context;
    private Future<DatanodeStateMachine.DatanodeStates> result;

    public InitDatanodeState(ConfigurationSource conf, SCMConnectionManager connectionManager, StateContext context) {
        this.conf = conf;
        this.connectionManager = connectionManager;
        this.context = context;
    }

    @Override
    public DatanodeStateMachine.DatanodeStates call() throws Exception {
        Collection addresses = null;
        try {
            addresses = HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)this.conf);
        }
        catch (IllegalArgumentException e) {
            if (!Strings.isNullOrEmpty((String)e.getMessage())) {
                LOG.error("Failed to get SCM addresses: {}", (Object)e.getMessage());
            }
            return DatanodeStateMachine.DatanodeStates.SHUTDOWN;
        }
        if (addresses.isEmpty()) {
            LOG.error("Null or empty SCM address list found.");
            return DatanodeStateMachine.DatanodeStates.SHUTDOWN;
        }
        for (InetSocketAddress addr : addresses) {
            if (!addr.isUnresolved()) continue;
            LOG.warn("One SCM address ({}) can't (yet?) be resolved. Postpone initialization.", (Object)addr);
            return this.context.getState();
        }
        for (InetSocketAddress addr : addresses) {
            this.connectionManager.addSCMServer(addr, this.context.getThreadNamePrefix());
            this.context.addEndpoint(addr);
        }
        InetSocketAddress reconAddress = HddsUtils.getReconAddresses((ConfigurationSource)this.conf);
        if (reconAddress != null) {
            this.connectionManager.addReconServer(reconAddress, this.context.getThreadNamePrefix());
            this.context.addEndpoint(reconAddress);
        }
        this.persistContainerDatanodeDetails();
        return this.context.getState().getNextState();
    }

    private void persistContainerDatanodeDetails() {
        String dataNodeIDPath = HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)this.conf);
        File idPath = new File(dataNodeIDPath);
        DatanodeDetails datanodeDetails = this.context.getParent().getDatanodeDetails();
        if (datanodeDetails != null) {
            try {
                ContainerUtils.writeDatanodeDetailsTo(datanodeDetails, idPath, this.conf);
            }
            catch (IOException ex) {
                LOG.error("Writing to {} failed {}", (Object)dataNodeIDPath, (Object)ex.getMessage());
                this.context.setState(DatanodeStateMachine.DatanodeStates.SHUTDOWN);
                return;
            }
            LOG.info("DatanodeDetails is persisted to {}", (Object)dataNodeIDPath);
        }
    }

    @Override
    public void onEnter() {
        LOG.trace("Entering init container state");
    }

    @Override
    public void onExit() {
        LOG.trace("Exiting init container state");
    }

    @Override
    public void execute(ExecutorService executor) {
        this.result = executor.submit(this);
    }

    public DatanodeStateMachine.DatanodeStates await(long time, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.result.get(time, timeUnit);
    }
}

