/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosePipelineCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClosePipelineCommandHandler.class);
    private final AtomicLong invocationCount = new AtomicLong(0L);
    private final AtomicInteger queuedCount = new AtomicInteger(0);
    private final Executor executor;
    private final BiFunction<RaftPeer, GrpcTlsConfig, RaftClient> newRaftClient;
    private final MutableRate opsLatencyMs;

    public ClosePipelineCommandHandler(ConfigurationSource conf, Executor executor) {
        this(RatisHelper.newRaftClientNoRetry((ConfigurationSource)conf), executor);
    }

    public ClosePipelineCommandHandler(BiFunction<RaftPeer, GrpcTlsConfig, RaftClient> newRaftClient, Executor executor) {
        this.newRaftClient = newRaftClient;
        this.executor = executor;
        MetricsRegistry registry = new MetricsRegistry(ClosePipelineCommandHandler.class.getSimpleName());
        this.opsLatencyMs = registry.newRate(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closePipelineCommand + "Ms");
    }

    @Override
    public void handle(SCMCommand<?> command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        this.queuedCount.incrementAndGet();
        CompletableFuture.runAsync(() -> {
            this.invocationCount.incrementAndGet();
            long startTime = Time.monotonicNow();
            DatanodeDetails dn = context.getParent().getDatanodeDetails();
            ClosePipelineCommand closePipelineCommand = (ClosePipelineCommand)command;
            PipelineID pipelineID = closePipelineCommand.getPipelineID();
            HddsProtos.PipelineID pipelineIdProto = pipelineID.getProtobuf();
            try {
                XceiverServerSpi server = ozoneContainer.getWriteChannel();
                if (server.isExist(pipelineIdProto)) {
                    if (server instanceof XceiverServerRatis) {
                        XceiverServerRatis ratisServer = (XceiverServerRatis)server;
                        RaftGroupId raftGroupId = RaftGroupId.valueOf((UUID)pipelineID.getId());
                        boolean shouldDeleteRatisLogDirectory = ratisServer.getShouldDeleteRatisLogDirectory();
                        Collection<RaftPeer> peers = ratisServer.getRaftPeersInPipeline(pipelineID);
                        peers.stream().filter(peer -> !peer.getId().equals((Object)ratisServer.getServer().getId())).forEach(peer -> {
                            try (RaftClient client = this.newRaftClient.apply((RaftPeer)peer, ozoneContainer.getTlsClientConfig());){
                                client.getGroupManagementApi(peer.getId()).remove(raftGroupId, shouldDeleteRatisLogDirectory, !shouldDeleteRatisLogDirectory);
                            }
                            catch (GroupMismatchException ae) {
                                LOG.debug("Failed to remove group {} for pipeline {} on peer {} since the group has been removed by earlier close pipeline command handled in another datanode", new Object[]{raftGroupId, pipelineID, peer.getId()});
                            }
                            catch (IOException ioe) {
                                LOG.warn("Failed to remove group {} of pipeline {} on peer {}", new Object[]{raftGroupId, pipelineID, peer.getId(), ioe});
                            }
                        });
                    }
                    server.removeGroup(pipelineIdProto);
                    LOG.info("Close Pipeline {} command on datanode {}.", (Object)pipelineID, (Object)dn.getUuidString());
                } else {
                    LOG.debug("Ignoring close pipeline command for pipeline {} on datanode {} as it does not exist", (Object)pipelineID, (Object)dn.getUuidString());
                }
            }
            catch (IOException e) {
                Throwable gme = HddsClientUtils.containsException((Throwable)e, GroupMismatchException.class);
                if (gme != null) {
                    LOG.debug("The group for pipeline {} on datanode {} has been removed by earlier close pipeline command handled in another datanode", (Object)pipelineID, (Object)dn.getUuidString());
                } else {
                    LOG.error("Can't close pipeline {}", (Object)pipelineID, (Object)e);
                }
            }
            finally {
                long endTime = Time.monotonicNow();
                this.opsLatencyMs.add(endTime - startTime);
            }
        }, this.executor).whenComplete((v, e) -> this.queuedCount.decrementAndGet());
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closePipelineCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        return (long)this.opsLatencyMs.lastStat().mean();
    }

    @Override
    public long getTotalRunTime() {
        return (long)this.opsLatencyMs.lastStat().total();
    }

    @Override
    public int getQueuedCount() {
        return this.queuedCount.get();
    }
}

