/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="revoke", description={"Revoke user accessId to tenant"})
public class TenantRevokeUserAccessIdHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Access ID"}, arity="1..1")
    private String accessId;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        client.getObjectStore().tenantRevokeUserAccessId(this.accessId);
        if (this.isVerbose()) {
            this.err().format("Revoked accessId '%s'.%n", this.accessId);
        }
    }
}

