/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdds.scm.cli.ScmOption;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.debug.replicas.Checksums;
import org.apache.hadoop.ozone.debug.replicas.FindMissingPadding;
import org.apache.hadoop.ozone.debug.replicas.ReplicaVerifier;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="verify", description={"Run checks to verify data across replicas"})
public class ReplicasVerify
extends Handler {
    @CommandLine.Mixin
    private ScmOption scmOption;
    @CommandLine.Parameters(arity="1", description={"Ozone URI could either be a full URI or short URI.\nFull URI should start with o3://, in case of non-HA\nclusters it should be followed by the host name and\noptionally the port number. In case of HA clusters\nthe service id should be used. Service id provides a\nlogical name for multiple hosts and it is defined\nin the property ozone.om.service.ids.\nExample of a full URI with host name and port number\nfor a key:\no3://omhostname:9862/vol1/bucket1/key1\nWith a service id for a volume:\no3://omserviceid/vol1/\nShort URI should start from the volume.\nExample of a short URI for a bucket:\nvol1/bucket1\nAny unspecified information will be identified from\nthe config files.\n"})
    private String uri;
    @CommandLine.Option(names={"-o", "--output-dir"}, description={"Destination directory to save the generated output."}, required=true)
    private String outputDir;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="1")
    private Verification verification;
    private FindMissingPadding findMissingPadding;
    private List<ReplicaVerifier> replicaVerifiers;

    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        this.replicaVerifiers = new ArrayList<ReplicaVerifier>();
        if (this.verification.doExecuteChecksums) {
            this.replicaVerifiers.add(new Checksums(client, this.outputDir, LOG, this.getConf()));
        }
        if (this.verification.doExecutePadding) {
            this.findMissingPadding = new FindMissingPadding(client, this.scmOption, LOG, this.out(), this.getConf());
            this.replicaVerifiers.add(this.findMissingPadding);
        }
        this.findCandidateKeys(client, address);
        if (this.verification.doExecutePadding) {
            this.findMissingPadding.execute();
        }
    }

    protected OzoneAddress getAddress() throws OzoneClientException {
        return new OzoneAddress(this.uri);
    }

    void findCandidateKeys(OzoneClient ozoneClient, OzoneAddress address) throws IOException {
        ObjectStore objectStore = ozoneClient.getObjectStore();
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        String keyName = address.getKeyName();
        if (!keyName.isEmpty()) {
            OzoneKeyDetails keyDetails = ozoneClient.getProxy().getKeyDetails(volumeName, bucketName, keyName);
            this.processKey(keyDetails);
        } else if (!bucketName.isEmpty()) {
            OzoneVolume volume = objectStore.getVolume(volumeName);
            OzoneBucket bucket = volume.getBucket(bucketName);
            this.checkBucket(bucket);
        } else if (!volumeName.isEmpty()) {
            OzoneVolume volume = objectStore.getVolume(volumeName);
            this.checkVolume(volume);
        } else {
            Iterator it = objectStore.listVolumes(null);
            while (it.hasNext()) {
                this.checkVolume((OzoneVolume)it.next());
            }
        }
    }

    void checkVolume(OzoneVolume volume) throws IOException {
        Iterator it = volume.listBuckets(null);
        while (it.hasNext()) {
            OzoneBucket bucket = (OzoneBucket)it.next();
            this.checkBucket(bucket);
        }
    }

    void checkBucket(OzoneBucket bucket) throws IOException {
        Iterator it = bucket.listKeys(null);
        while (it.hasNext()) {
            OzoneKey key = (OzoneKey)it.next();
            if (key.getName().endsWith("/")) continue;
            this.processKey(bucket.getKey(key.getName()));
        }
    }

    void processKey(OzoneKeyDetails keyDetails) {
        this.replicaVerifiers.forEach(verifier -> verifier.verifyKey(keyDetails));
    }

    static class Verification {
        @CommandLine.Option(names={"--checksums"}, description={"Do client side data checksum validation of all replicas."}, defaultValue="false")
        private boolean doExecuteChecksums;
        @CommandLine.Option(names={"--padding"}, description={"Check for missing padding in erasure coded replicas."}, defaultValue="false")
        private boolean doExecutePadding;

        Verification() {
        }
    }
}

