/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.audit.parser.handler;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.debug.audit.parser.AuditParser;
import org.apache.hadoop.ozone.debug.audit.parser.common.DatabaseHelper;
import picocli.CommandLine;

@CommandLine.Command(name="template", aliases={"t"}, description={"Execute template query.\n\nTo run a template query on the audit logs loaded to the database:\nozone debug auditparser <path to db file> template <template>\n\nFollowing templates are available:\n(Template)              (Description)\ntop5users              : Top 5 users.\ntop5cmds               : Top 5 commands.\ntop5activetimebyseconds: Top 5 active times, grouped by seconds.\n"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class TemplateCommandHandler
implements Callable<Void> {
    @CommandLine.Parameters(arity="1..1", description={"Custom query"})
    private String template;
    @CommandLine.ParentCommand
    private AuditParser auditParser;

    @Override
    public Void call() throws Exception {
        try {
            if (DatabaseHelper.validateTemplate(this.template)) {
                System.out.println(DatabaseHelper.executeTemplate(this.auditParser.getDatabase(), this.template));
            } else {
                System.err.println("ERROR: Invalid template name - " + this.template);
            }
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
        }
        return null;
    }
}

