/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.StreamBufferArgs;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class ECBlockOutputStream
extends BlockOutputStream {
    private final DatanodeDetails datanodeDetails;
    private CompletableFuture<ContainerProtos.ContainerCommandResponseProto> currentChunkRspFuture = null;
    private CompletableFuture<ContainerProtos.ContainerCommandResponseProto> putBlkRspFuture = null;

    public ECBlockOutputStream(BlockID blockID, XceiverClientFactory xceiverClientManager, Pipeline pipeline, BufferPool bufferPool, OzoneClientConfig config, Token<? extends TokenIdentifier> token, ContainerClientMetrics clientMetrics, StreamBufferArgs streamBufferArgs, Supplier<ExecutorService> executorServiceSupplier) throws IOException {
        super(blockID, -1L, xceiverClientManager, pipeline, bufferPool, config, token, clientMetrics, streamBufferArgs, executorServiceSupplier);
        this.datanodeDetails = pipeline.getClosestNode();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.currentChunkRspFuture = this.writeChunkToContainer(ChunkBuffer.wrap((ByteBuffer)ByteBuffer.wrap(b, off, len)));
        this.updateWrittenDataLength(len);
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> write(ByteBuffer buff) throws IOException {
        return this.writeChunkToContainer(ChunkBuffer.wrap((ByteBuffer)buff));
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> executePutBlock(boolean close, boolean force, long blockGroupLength, BlockData[] blockData) throws IOException {
        ECReplicationConfig repConfig = (ECReplicationConfig)this.getPipeline().getReplicationConfig();
        int totalNodes = repConfig.getRequiredNodes();
        int parity = repConfig.getParity();
        if (this.getReplicationIndex() > 1 && this.getReplicationIndex() <= totalNodes - parity) {
            return this.executePutBlock(close, force, blockGroupLength);
        }
        BlockData checksumBlockData = null;
        BlockID blockID = null;
        for (int i = blockData.length - 1; i >= 0; --i) {
            List chunks;
            BlockData bd = blockData[i];
            if (bd == null) continue;
            if (blockID == null) {
                blockID = bd.getBlockID();
            }
            if ((chunks = bd.getChunks()) == null || chunks.isEmpty()) continue;
            if (((ContainerProtos.ChunkInfo)chunks.get(0)).hasStripeChecksum()) {
                checksumBlockData = bd;
                break;
            }
            ContainerProtos.ChunkInfo chunk = (ContainerProtos.ChunkInfo)chunks.get(0);
            LOG.debug("The first chunk in block with index {} does not have stripeChecksum. BlockID: {}, Block size: {}. Chunk length: {}, Chunk offset: {}, hasChecksumData: {}, chunks size: {}.", new Object[]{i, bd.getBlockID(), bd.getSize(), chunk.getLen(), chunk.getOffset(), chunk.hasChecksumData(), chunks.size()});
        }
        if (checksumBlockData != null) {
            List currentChunks;
            Map<Long, Optional<BlockData>> maxDataSizeByGroup = Arrays.stream(blockData).filter(Objects::nonNull).collect(Collectors.groupingBy(BlockData::getBlockGroupLength, Collectors.maxBy(Comparator.comparingLong(BlockData::getSize))));
            BlockData maxBlockData = maxDataSizeByGroup.get(blockGroupLength).get();
            long blockDataSize = Math.min(maxBlockData.getSize(), blockGroupLength);
            int chunkSize = (int)Math.ceil((double)blockDataSize / (double)repConfig.getEcChunkSize());
            List checksumBlockDataChunks = checksumBlockData.getChunks();
            if (chunkSize > 0) {
                checksumBlockDataChunks = checksumBlockData.getChunks().subList(0, chunkSize);
            }
            Preconditions.checkArgument(((currentChunks = this.getContainerBlockData().getChunksList()).size() == checksumBlockDataChunks.size() ? 1 : 0) != 0, (Object)("The chunk list has " + currentChunks.size() + " entries, but the checksum chunks has " + checksumBlockDataChunks.size() + " entries. They should be equal in size."));
            ArrayList<ContainerProtos.ChunkInfo> newChunkList = new ArrayList<ContainerProtos.ChunkInfo>();
            for (int i = 0; i < currentChunks.size(); ++i) {
                ContainerProtos.ChunkInfo chunkInfo = (ContainerProtos.ChunkInfo)currentChunks.get(i);
                ContainerProtos.ChunkInfo checksumChunk = (ContainerProtos.ChunkInfo)checksumBlockDataChunks.get(i);
                ContainerProtos.ChunkInfo.Builder builder = ContainerProtos.ChunkInfo.newBuilder((ContainerProtos.ChunkInfo)chunkInfo);
                if (chunkInfo.hasChecksumData()) {
                    builder.setStripeChecksum(checksumChunk.getStripeChecksum());
                }
                ContainerProtos.ChunkInfo newInfo = builder.build();
                newChunkList.add(newInfo);
            }
            this.getContainerBlockData().clearChunks();
            this.getContainerBlockData().addAllChunks(newChunkList);
        } else {
            LOG.warn("Could not find checksum data in any index for blockData with BlockID {}, length {} and blockGroupLength {}.", new Object[]{blockID, blockData.length, blockGroupLength});
        }
        return this.executePutBlock(close, force, blockGroupLength);
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> executePutBlock(boolean close, boolean force, long blockGroupLength, ByteString checksum) throws IOException {
        ECReplicationConfig repConfig = (ECReplicationConfig)this.getPipeline().getReplicationConfig();
        int totalNodes = repConfig.getRequiredNodes();
        int parity = repConfig.getParity();
        if (this.getReplicationIndex() <= 1 || this.getReplicationIndex() > totalNodes - parity) {
            this.updateChecksum(checksum);
        }
        return this.executePutBlock(close, force, blockGroupLength);
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> executePutBlock(boolean close, boolean force, long blockGroupLength) throws IOException {
        this.updateBlockGroupLengthInPutBlockMeta(blockGroupLength);
        return this.executePutBlock(close, force).thenApply(BlockOutputStream.PutBlockResult::getResponse);
    }

    private void updateBlockGroupLengthInPutBlockMeta(long blockGroupLen) {
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("blockGroupLen").setValue(String.valueOf(blockGroupLen)).build();
        List metadataList = this.getContainerBlockData().getMetadataList().stream().filter(kv -> !Objects.equals(kv.getKey(), "blockGroupLen")).collect(Collectors.toList());
        metadataList.add(keyValue);
        this.getContainerBlockData().clearMetadata();
        this.getContainerBlockData().addAllMetadata(metadataList);
    }

    private void updateChecksum(ByteString checksum) {
        int size = this.getContainerBlockData().getChunksCount();
        if (size > 0) {
            ContainerProtos.ChunkInfo oldInfo = this.getContainerBlockData().getChunks(size - 1);
            ContainerProtos.ChunkInfo newInfo = ContainerProtos.ChunkInfo.newBuilder((ContainerProtos.ChunkInfo)oldInfo).setStripeChecksum(checksum).build();
            this.getContainerBlockData().removeChunks(size - 1);
            this.getContainerBlockData().addChunks(newInfo);
        }
    }

    @Override
    public CompletableFuture<BlockOutputStream.PutBlockResult> executePutBlock(boolean close, boolean force) throws IOException {
        CompletionStage flushFuture;
        this.checkOpen();
        try {
            ContainerProtos.BlockData blockData = this.getContainerBlockData().build();
            XceiverClientReply asyncReply = ContainerProtocolCalls.putBlockAsync((XceiverClientSpi)this.getXceiverClient(), (ContainerProtos.BlockData)blockData, (boolean)close, (String)this.getTokenString());
            CompletableFuture future = asyncReply.getResponse();
            flushFuture = ((CompletableFuture)future.thenApplyAsync(e -> {
                try {
                    this.validateResponse((ContainerProtos.ContainerCommandResponseProto)e);
                }
                catch (IOException sce) {
                    throw new CompletionException(sce);
                }
                if (this.getIoException() == null) {
                    BlockID responseBlockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)e.getPutBlock().getCommittedBlockLength().getBlockID());
                    Preconditions.checkState((boolean)this.getBlockID().getContainerBlockID().equals((Object)responseBlockID.getContainerBlockID()));
                }
                return e;
            }, (Executor)this.getResponseExecutor())).exceptionally(e -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("putBlock failed for blockID {} with exception {}", (Object)this.getBlockID(), (Object)e.getLocalizedMessage());
                }
                CompletionException ce = new CompletionException((Throwable)e);
                this.setIoException(ce);
                throw ce;
            });
        }
        catch (IOException | ExecutionException e2) {
            throw new IOException("Unexpected Storage Container Exception: " + e2, e2);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.handleInterruptedException(ex, false);
            return null;
        }
        this.putBlkRspFuture = flushFuture;
        return ((CompletableFuture)flushFuture).thenApply(r -> new BlockOutputStream.PutBlockResult(0L, (ContainerProtos.ContainerCommandResponseProto)r));
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> getCurrentChunkResponseFuture() {
        return this.currentChunkRspFuture;
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> getCurrentPutBlkResponseFuture() {
        return this.putBlkRspFuture;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    @Override
    void validateResponse(ContainerProtos.ContainerCommandResponseProto responseProto) throws IOException {
        try {
            IOException exception = this.getIoException();
            if (exception != null) {
                return;
            }
            ContainerProtocolCalls.validateContainerResponse((ContainerProtos.ContainerCommandResponseProto)responseProto);
        }
        catch (IOException sce) {
            this.setIoException(sce);
        }
    }
}

